/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.groups;

import ambit2.core.groups.AbstractGroup;
import ambit2.core.groups.IExpandable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;

public class MultipleGroup
extends AbstractGroup
implements IExpandable {
    protected int multiplier;
    protected int number;
    protected List<IAtom> parentAtoms = null;
    protected List<IBond> parentBonds = null;
    boolean expanded = true;
    private static final long serialVersionUID = -9110648470808236343L;

    public MultipleGroup(String string, int n) {
        super(string, n);
        MultipleGroup.setGroupVisible((IChemObject)this, false);
    }

    public synchronized int getMultiplier() {
        return this.multiplier;
    }

    public synchronized void setMultiplier(int n) {
        this.multiplier = n;
    }

    public void addParentAtom(IAtom iAtom) {
        if (this.parentAtoms == null) {
            this.parentAtoms = new ArrayList<IAtom>();
        }
        this.parentAtoms.add(iAtom);
    }

    @Override
    public void setExpanded(boolean bl) {
        if (this.expanded != bl) {
            for (IAtom iAtom : this.getAtoms(this.expanded)) {
                MultipleGroup.setGroupVisible((IChemObject)iAtom, false);
            }
            for (IBond iBond : this.getBonds(this.expanded)) {
                MultipleGroup.setGroupVisible((IChemObject)iBond, false);
            }
            this.expanded = bl;
            for (IAtom iAtom : this.getAtoms(this.expanded)) {
                MultipleGroup.setGroupVisible((IChemObject)iAtom, true);
            }
            for (IBond iBond : this.getBonds(this.expanded)) {
                MultipleGroup.setGroupVisible((IChemObject)iBond, true);
            }
        }
    }

    @Override
    public Iterable<IAtom> getAtoms(boolean bl) {
        if (bl) {
            return new Iterable<IAtom>(){

                @Override
                public Iterator<IAtom> iterator() {
                    return MultipleGroup.this.atoms.iterator();
                }
            };
        }
        return new Iterable<IAtom>(){

            @Override
            public Iterator<IAtom> iterator() {
                return MultipleGroup.this.parentAtoms.iterator();
            }
        };
    }

    @Override
    public Iterable<IBond> getBonds(boolean bl) {
        if (bl) {
            return new Iterable<IBond>(){

                @Override
                public Iterator<IBond> iterator() {
                    return MultipleGroup.this.bonds.iterator();
                }
            };
        }
        return new Iterable<IBond>(){

            @Override
            public Iterator<IBond> iterator() {
                return MultipleGroup.this.parentBonds.iterator();
            }
        };
    }

    @Override
    public void finalizeAtomList(IAtomContainer iAtomContainer) {
        if (this.bonds == null) {
            this.bonds = new ArrayList();
        }
        this.addBondsConnected2Atoms(iAtomContainer, this.atoms, this.bonds);
    }

    public void finalizeParentAtomList(IAtomContainer iAtomContainer) {
        if (this.parentBonds == null) {
            this.parentBonds = new ArrayList<IBond>();
        }
        if (this.parentAtoms != null) {
            this.addBondsConnected2Atoms(iAtomContainer, this.parentAtoms, this.parentBonds);
        }
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }
}

