/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts.processors;

import ambit2.base.data.Property;
import ambit2.base.exceptions.AmbitException;
import ambit2.core.processors.structure.AbstractPropertyGenerator;
import ambit2.core.processors.structure.AtomConfigurator;
import ambit2.smarts.CMLUtilities;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMolecule;

public class SMARTSPropertiesGenerator
extends AbstractPropertyGenerator<String> {
    protected CMLUtilities utils = new CMLUtilities();
    protected AtomConfigurator config = new AtomConfigurator();
    private static final long serialVersionUID = -3259442103743490512L;

    @Override
    protected String generateProperty(IAtomContainer atomContainer) throws AmbitException {
        if (atomContainer == null || atomContainer.getAtomCount() == 0) {
            throw new AmbitException("Empty molecule");
        }
        try {
            int i;
            IAtomContainer c = this.config.process(atomContainer);
            try {
                CDKHueckelAromaticityDetector.detectAromaticity((IAtomContainer)c);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            StringBuilder b = new StringBuilder();
            this.utils.setCMLSMARTSProperties((IMolecule)atomContainer);
            for (i = 0; i < atomContainer.getAtomCount(); ++i) {
                b.append(atomContainer.getAtom(i).getProperty((Object)"SMARTSProp"));
                b.append(',');
            }
            b.append('\n');
            for (i = 0; i < atomContainer.getBondCount(); ++i) {
                b.append(atomContainer.getBond(i).getFlag(5) ? 1 : 0);
                b.append(',');
            }
            return b.toString();
        }
        catch (AmbitException x) {
            return "";
        }
        catch (Exception x) {
            return "";
        }
    }

    @Override
    protected Property getProperty() {
        return Property.getInstance((String)"SMARTSProp", (String)"SMARTSProp");
    }

    @Override
    protected Property getTimeProperty() {
        return null;
    }
}

