/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.smiles.smarts.SMARTSQueryTool;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class McGowanVolumeDescriptor
implements IMolecularDescriptor {
    public static final String[] names = new String[]{"McGowan_Volume"};
    private static String[] atomTypes = new String[]{"[#6]", "[#7]", "[#8]", "[#9]", "[#1]", "[#14]", "[#15]", "[#16]", "[#17]", "[#5]", "[#32]", "[#33]", "[#34]", "[#35]", "[#50]", "[#51]", "[#52]", "[#53]"};
    private static double[] coefAtomTypes = new double[]{16.35, 14.39, 12.43, 10.48, 8.71, 26.83, 24.87, 22.91, 20.95, 18.32, 31.02, 29.42, 27.81, 26.21, 39.35, 37.74, 36.14, 34.53};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("McGowen_V", this.getClass().getName(), "$Id: McGowenVolumeDescriptor.java 1 2008-07-07 06:50:01Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        int n = this.getDescriptorNames().length;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayResult.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), exception);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        try {
            SMARTSQueryTool sMARTSQueryTool = new SMARTSQueryTool("C");
            int n = atomTypes.length;
            double d = 0.0;
            for (int i = 0; i < n; ++i) {
                if (atomTypes[i].equals("[#1]")) {
                    for (IAtom iAtom : iAtomContainer.atoms()) {
                        if (iAtom.getSymbol().equals("H")) continue;
                        d += (double)AtomContainerManipulator.countHydrogens(iAtomContainer, iAtom) * coefAtomTypes[i];
                    }
                    continue;
                }
                sMARTSQueryTool.setSmarts(atomTypes[i]);
                if (!sMARTSQueryTool.matches(iAtomContainer)) continue;
                d += (double)sMARTSQueryTool.getUniqueMatchingAtoms().size() * coefAtomTypes[i];
            }
            d -= (double)iAtomContainer.getBondCount() * 6.56;
            DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
            doubleArrayResult.add(d /= 100.0);
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, names);
        }
        catch (Exception exception) {
            return this.getDummyDescriptorValue(new CDKException("Error in SMARTSQueryTool: " + exception.getMessage()));
        }
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(names.length);
    }
}

