/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;

public class CDK_Descriptor
extends Thread {
    protected IMolecularDescriptor cdkDescriptor_;
    protected IAtomContainer molecule_;
    protected String[] descriptorValues_;
    protected String errorCode_ = "";
    protected int maxDescriptors_ = 0;

    @Override
    public void run() {
        this.initDescriptorsValues();
        DescriptorValue descriptorValue = this.cdkDescriptor_.calculate(this.molecule_);
        if (descriptorValue.getException() != null) {
            Logger.getLogger("global").log(Level.FINE, this.cdkDescriptor_.toString() + ":" + descriptorValue.getException().toString());
        }
        String[] stringArray = ((Object)descriptorValue.getValue()).toString().split(",");
        int n = this.getDescriptorCount();
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].equals("NaN")) continue;
            this.descriptorValues_[i] = stringArray[i];
        }
    }

    @Override
    public void interrupt() {
        this.molecule_ = null;
        this.stop();
        super.interrupt();
    }

    public void initDescriptorsValues() {
        int n = this.getDescriptorCount();
        this.descriptorValues_ = new String[n];
        for (int i = 0; i < n; ++i) {
            this.descriptorValues_[i] = this.errorCode_;
        }
    }

    public int getDescriptorCount() {
        if (this.maxDescriptors_ == 0) {
            this.maxDescriptors_ = this.cdkDescriptor_.getDescriptorResultType().length();
        }
        return this.maxDescriptors_;
    }

    public String[] getDescriptorNames() {
        return this.cdkDescriptor_.getDescriptorNames();
    }

    public String[] getDescriptorValues() {
        return (String[])this.descriptorValues_.clone();
    }

    public void setMolecule(IAtomContainer iAtomContainer) {
        this.molecule_ = iAtomContainer;
        this.initDescriptorsValues();
    }

    public void setErrorCode(String string) {
        this.errorCode_ = string;
    }

    public void setParameters(Object[] objectArray) throws CDKException {
        this.cdkDescriptor_.setParameters(objectArray);
    }
}

