/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts.processors;

import ambit2.base.data.Property;
import ambit2.base.exceptions.AmbitException;
import ambit2.base.processors.DefaultAmbitProcessor;
import ambit2.smarts.CMLUtilities;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMolecule;

public class SMARTSPropertiesReader
extends DefaultAmbitProcessor<IAtomContainer, IAtomContainer> {
    protected CMLUtilities util = new CMLUtilities();
    private static final long serialVersionUID = -2900200524126295738L;

    public IAtomContainer process(IAtomContainer mol) throws AmbitException {
        Property p = this.getProperty();
        if (mol.getProperty((Object)p) == null) {
            return null;
        }
        String[] prop = mol.getProperty((Object)p).toString().split("\n");
        String[] atomprops = prop[0].split(",");
        for (int i = 0; i < atomprops.length; ++i) {
            mol.getAtom(i).setProperty((Object)"SMARTSProp", (Object)atomprops[i]);
        }
        if (prop.length == 1) {
            logger.warn((Object)"Bond properties missing!");
        } else {
            int i;
            String[] bondprop = prop[1].split(",");
            for (i = 0; i < mol.getAtomCount(); ++i) {
                mol.getAtom(i).setFlag(5, false);
            }
            for (i = 0; i < bondprop.length; ++i) {
                boolean aromatic = bondprop[i].equals("1");
                IBond bond = mol.getBond(i);
                bond.setFlag(5, aromatic);
                for (int b = 0; b < bond.getAtomCount(); ++b) {
                    if (!aromatic) continue;
                    bond.getAtom(b).setFlag(5, true);
                }
            }
        }
        if (this.util == null) {
            this.util = new CMLUtilities();
        }
        this.util.extractSMARTSProperties((IMolecule)mol);
        return mol;
    }

    protected Property getProperty() {
        return Property.getInstance((String)"SMARTSProp", (String)"SMARTSProp");
    }
}

