/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts;

import ambit2.core.processors.structure.AtomConfigurator;
import ambit2.smarts.EquivalenceTester;
import ambit2.smarts.IAcceptable;
import ambit2.smarts.IsomorphismTester;
import ambit2.smarts.SMIRKSReaction;
import ambit2.smarts.SmartsFlags;
import ambit2.smarts.SmartsParser;
import ambit2.smarts.SmartsToChemObject;
import java.util.Vector;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.AtomContainerSet;
import org.openscience.cdk.Bond;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;

public class SMIRKSManager {
    SmartsParser parser = new SmartsParser();
    IsomorphismTester isoTester = new IsomorphismTester();
    SmartsToChemObject stco;
    EquivalenceTester eqTester = new EquivalenceTester();
    Vector<String> parserErrors = new Vector();
    public int FlagSSMode = 1;
    public boolean FlagFilterEquivalentMappings = false;

    public SMIRKSManager(IChemObjectBuilder builder) {
        this.parser.setComponentLevelGrouping(true);
        this.parser.mSupportSmirksSyntax = true;
        this.stco = new SmartsToChemObject(builder);
    }

    public void setSSMode(int mode) {
        this.FlagSSMode = mode;
    }

    public boolean hasErrors() {
        return !this.parserErrors.isEmpty();
    }

    public String getErrors() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.parserErrors.size(); ++i) {
            sb.append(this.parserErrors.get(i) + "\n");
        }
        return sb.toString();
    }

    public SMIRKSReaction parse(String smirks) {
        this.parserErrors.clear();
        SMIRKSReaction reaction = new SMIRKSReaction(this.stco.getBuilder());
        int sep1Pos = smirks.indexOf(">");
        if (sep1Pos == -1) {
            this.parserErrors.add("Invalid SMIRKS: missing separators '>'");
            return reaction;
        }
        int sep2Pos = smirks.indexOf(">", sep1Pos + 1);
        if (sep2Pos == -1) {
            this.parserErrors.add("Invalid SMIRKS: missing second separator '>'");
            return reaction;
        }
        int res = 0;
        reaction.reactantsSmarts = smirks.substring(0, sep1Pos).trim();
        QueryAtomContainer fragment = this.parseComponent(reaction.reactantsSmarts, "Reactants", reaction.reactantFlags, reaction.reactants, reaction.reactantCLG);
        if (fragment == null) {
            ++res;
        } else {
            reaction.reactant = fragment;
        }
        reaction.agentsSmarts = smirks.substring(sep1Pos + 1, sep2Pos).trim();
        if (!reaction.agentsSmarts.equals("")) {
            fragment = this.parseComponent(reaction.agentsSmarts, "Agents", reaction.agentFlags, reaction.agents, reaction.agentsCLG);
            if (fragment == null) {
                ++res;
            } else {
                reaction.agent = fragment;
            }
        }
        reaction.productsSmarts = smirks.substring(sep2Pos + 1).trim();
        fragment = this.parseComponent(reaction.productsSmarts, "Products", reaction.productFlags, reaction.products, reaction.productsCLG);
        if (fragment == null) {
            ++res;
        } else {
            reaction.product = fragment;
        }
        if (res > 0) {
            return reaction;
        }
        reaction.checkMappings();
        if (reaction.mapErrors.size() > 0) {
            this.parserErrors.addAll(reaction.mapErrors);
            return reaction;
        }
        reaction.generateTransformationData();
        return reaction;
    }

    public QueryAtomContainer parseComponent(String smarts, String compType, SmartsFlags flags, Vector<QueryAtomContainer> fragments, Vector<Integer> CLG) {
        int i;
        QueryAtomContainer fragment = this.parser.parse(smarts);
        this.parser.setNeededDataFlags();
        String errorMsg = this.parser.getErrorMessages();
        if (!errorMsg.equals("")) {
            this.parserErrors.add("Invalid " + compType + " part in SMIRKS: " + smarts + "   " + errorMsg);
            return null;
        }
        flags.hasRecursiveSmarts = this.parser.hasRecursiveSmarts;
        flags.mNeedExplicitHData = this.parser.needExplicitHData();
        flags.mNeedNeighbourData = this.parser.needNeighbourData();
        flags.mNeedParentMoleculeData = this.parser.needParentMoleculeData();
        flags.mNeedRingData = this.parser.needRingData();
        flags.mNeedRingData2 = this.parser.needRingData2();
        flags.mNeedValenceData = this.parser.needValencyData();
        for (i = 0; i < this.parser.fragments.size(); ++i) {
            fragments.add(this.parser.fragments.get(i));
        }
        for (i = 0; i < this.parser.fragmentComponents.size(); ++i) {
            CLG.add(this.parser.fragmentComponents.get(i));
        }
        return fragment;
    }

    public boolean applyTransformation(IAtomContainer target, SMIRKSReaction reaction) throws Exception {
        return this.applyTransformation(target, null, reaction);
    }

    public boolean applyTransformation(IAtomContainer target, IAcceptable selection, SMIRKSReaction reaction) throws Exception {
        this.isoTester.setQuery(reaction.reactant);
        SmartsParser.prepareTargetForSMARTSSearch(reaction.reactantFlags, target);
        if (this.FlagSSMode == 0) {
            return false;
        }
        if (this.FlagSSMode == 2) {
            Vector<Vector<IAtom>> rMaps = this.getNonIdenticalMappings(target);
            if (rMaps.size() == 0) {
                return false;
            }
            if (this.FlagFilterEquivalentMappings) {
                this.eqTester.setTarget(target);
                this.eqTester.quickFindEquivalentTerminalHAtoms();
                rMaps = this.eqTester.filterEquivalentMappings(rMaps);
            }
            boolean applied = false;
            for (int i = 0; i < rMaps.size(); ++i) {
                if (selection != null && (selection == null || !selection.accept(rMaps.get(i)))) continue;
                this.applyTransformAtLocation(target, rMaps.get(i), reaction);
                applied = true;
            }
            AtomConfigurator cfg = new AtomConfigurator();
            cfg.process(target);
            return applied;
        }
        if (this.FlagSSMode == 21) {
            Vector<Vector<IAtom>> rMaps = this.getNonIdenticalMappings(target);
            if (rMaps.size() == 0) {
                return false;
            }
            boolean applied = false;
            for (int i = 0; i < rMaps.size(); ++i) {
                if (selection != null && (selection == null || !selection.accept(rMaps.get(i)))) continue;
                this.applyTransformAtLocation(target, rMaps.get(i), reaction);
                applied = true;
                AtomConfigurator cfg = new AtomConfigurator();
                cfg.process(target);
                return applied;
            }
            return applied;
        }
        if (this.FlagSSMode == 1) {
            Vector<Vector<IAtom>> rMaps = this.getNonOverlappingMappings(target);
            if (rMaps.size() == 0) {
                return false;
            }
            boolean applied = false;
            for (int i = 0; i < rMaps.size(); ++i) {
                if (selection != null && (selection == null || !selection.accept(rMaps.get(i)))) continue;
                this.applyTransformAtLocation(target, rMaps.get(i), reaction);
                applied = true;
            }
            AtomConfigurator cfg = new AtomConfigurator();
            cfg.process(target);
            return applied;
        }
        return false;
    }

    public IAtomContainerSet applyTransformationWithCombinedOverlappedPos(IAtomContainer target, IAcceptable selection, SMIRKSReaction reaction) throws Exception {
        Vector<Vector<IAtom>> rMaps;
        this.isoTester.setQuery(reaction.reactant);
        SmartsParser.prepareTargetForSMARTSSearch(reaction.reactantFlags, target);
        Vector<Vector<IAtom>> rMaps0 = this.getNonIdenticalMappings(target);
        if (rMaps0.size() == 0) {
            return null;
        }
        if (selection == null) {
            rMaps = rMaps0;
        } else {
            rMaps = new Vector();
            for (int i = 0; i < rMaps0.size(); ++i) {
                if (!selection.accept(rMaps0.get(i))) continue;
                rMaps.add(rMaps0.get(i));
            }
        }
        if (rMaps.size() == 0) {
            return null;
        }
        if (this.FlagFilterEquivalentMappings) {
            this.eqTester.setTarget(target);
            this.eqTester.quickFindEquivalentTerminalHAtoms();
            rMaps = this.eqTester.filterEquivalentMappings(rMaps);
        }
        AtomContainerSet resSet = new AtomContainerSet();
        if (rMaps.size() == 1) {
            IAtomContainer product = this.applyTransformationsAtLocationsWithCloning(target, rMaps, reaction);
            resSet.addAtomContainer(product);
            return resSet;
        }
        Vector<Vector<Integer>> clusterIndexes = this.isoTester.getOverlappedMappingClusters(rMaps);
        int[] comb = new int[clusterIndexes.size()];
        for (int i = 0; i < comb.length; ++i) {
            comb[i] = 0;
        }
        int digit = 0;
        block2: do {
            Vector<Vector<IAtom>> combMaps = new Vector<Vector<IAtom>>();
            for (int i = 0; i < comb.length; ++i) {
                int index = clusterIndexes.get(i).get(comb[i]);
                combMaps.add(rMaps.get(index));
            }
            IAtomContainer product = this.applyTransformationsAtLocationsWithCloning(target, combMaps, reaction);
            resSet.addAtomContainer(product);
            for (digit = 0; digit < comb.length; ++digit) {
                int n = digit;
                comb[n] = comb[n] + 1;
                if (comb[digit] != clusterIndexes.get(digit).size()) continue block2;
                comb[digit] = 0;
            }
        } while (digit < comb.length);
        return resSet;
    }

    public IAtomContainerSet applyTransformationWithSingleCopyForEachPos(IAtomContainer target, IAcceptable selection, SMIRKSReaction reaction) throws Exception {
        Vector<Vector<IAtom>> rMaps;
        this.isoTester.setQuery(reaction.reactant);
        SmartsParser.prepareTargetForSMARTSSearch(reaction.reactantFlags, target);
        Vector<Vector<IAtom>> rMaps0 = this.getNonIdenticalMappings(target);
        if (rMaps0.size() == 0) {
            return null;
        }
        if (selection == null) {
            rMaps = rMaps0;
        } else {
            rMaps = new Vector();
            for (int i = 0; i < rMaps0.size(); ++i) {
                if (!selection.accept(rMaps0.get(i))) continue;
                rMaps.add(rMaps0.get(i));
            }
        }
        if (rMaps.size() == 0) {
            return null;
        }
        if (this.FlagFilterEquivalentMappings) {
            this.eqTester.setTarget(target);
            this.eqTester.quickFindEquivalentTerminalHAtoms();
            rMaps = this.eqTester.filterEquivalentMappings(rMaps);
        }
        AtomContainerSet resSet = new AtomContainerSet();
        for (int i = 0; i < rMaps.size(); ++i) {
            Vector<Vector<IAtom>> vMaps = new Vector<Vector<IAtom>>();
            vMaps.add(rMaps.get(i));
            IAtomContainer product = this.applyTransformationsAtLocationsWithCloning(target, vMaps, reaction);
            resSet.addAtomContainer(product);
        }
        return resSet;
    }

    public Vector<Vector<IAtom>> getNonOverlappingMappings(IAtomContainer target) {
        Vector<Vector<IAtom>> rMaps = this.isoTester.getNonOverlappingMappings(target);
        return rMaps;
    }

    public Vector<Vector<IAtom>> getNonIdenticalMappings(IAtomContainer target) {
        Vector<Vector<IAtom>> rMaps = this.isoTester.getNonIdenticalMappings(target);
        return rMaps;
    }

    public void applyTransformAtLocation(IAtomContainer target, Vector<IAtom> rMap, SMIRKSReaction reaction) {
        int i;
        Vector<IAtom> newAtoms = new Vector<IAtom>();
        for (i = 0; i < reaction.productNotMappedAt.size(); ++i) {
            int pAtNum = reaction.productNotMappedAt.get(i);
            IAtom a = reaction.product.getAtom(pAtNum);
            IAtom a0 = this.stco.toAtom(a);
            newAtoms.add(a0);
            target.addAtom(a0);
        }
        for (i = 0; i < reaction.reactant.getAtomCount(); ++i) {
            IAtom rAt = reaction.reactant.getAtom(i);
            Integer raMapInd = (Integer)rAt.getProperty((Object)"SmirksMapIndex");
            if (raMapInd != null) {
                int pAtNum = reaction.getMappedProductAtom(raMapInd);
                Integer charge = reaction.productAtCharge.get(pAtNum);
                IAtom tAt = rMap.get(i);
                tAt.setFormalCharge(charge);
                continue;
            }
            IAtom tAt = rMap.get(i);
            target.removeAtomAndConnectedElectronContainers(tAt);
        }
        for (i = 0; i < reaction.reactBo.size(); ++i) {
            int k;
            Bond tb;
            IAtom tAt2;
            IAtom tAt1;
            int nrAt1 = reaction.reactAt1.get(i);
            int nrAt2 = reaction.reactAt2.get(i);
            if (nrAt1 >= 0 && nrAt2 >= 0) {
                if (reaction.reactBo.get(i) == null) {
                    tAt1 = rMap.get(nrAt1);
                    tAt2 = rMap.get(nrAt2);
                    tb = new Bond();
                    tb.setAtoms(new IAtom[]{tAt1, tAt2});
                    tb.setOrder(reaction.prodBo.get(i));
                    target.addBond((IBond)tb);
                    continue;
                }
                tAt1 = rMap.get(nrAt1);
                tAt2 = rMap.get(nrAt2);
                IBond tBo = target.getBond(tAt1, tAt2);
                if (reaction.prodBo.get(i) == null) {
                    target.removeBond(tBo);
                    continue;
                }
                tBo.setOrder(reaction.prodBo.get(i));
                continue;
            }
            if (nrAt1 != -100000 && nrAt2 != -100000) continue;
            tAt1 = null;
            tAt2 = null;
            if (nrAt1 == -100000) {
                int pAt1tNotMapIndex = -1;
                int npAt1 = reaction.prodAt1.get(i);
                for (k = 0; k < reaction.productNotMappedAt.size(); ++k) {
                    if (reaction.productNotMappedAt.get(k) != npAt1) continue;
                    pAt1tNotMapIndex = k;
                    break;
                }
                tAt1 = (IAtom)newAtoms.get(pAt1tNotMapIndex);
            } else {
                tAt1 = rMap.get(nrAt1);
            }
            if (nrAt2 == -100000) {
                int pAt2tNotMapIndex = -1;
                int npAt2 = reaction.prodAt2.get(i);
                for (k = 0; k < reaction.productNotMappedAt.size(); ++k) {
                    if (reaction.productNotMappedAt.get(k) != npAt2) continue;
                    pAt2tNotMapIndex = k;
                    break;
                }
                tAt2 = (IAtom)newAtoms.get(pAt2tNotMapIndex);
            } else {
                tAt2 = rMap.get(nrAt2);
            }
            tb = new Bond();
            tb.setAtoms(new IAtom[]{tAt1, tAt2});
            tb.setOrder(reaction.prodBo.get(i));
            target.addBond((IBond)tb);
        }
    }

    public IAtomContainer applyTransformationsAtLocationsWithCloning(IAtomContainer target, Vector<Vector<IAtom>> rMaps, SMIRKSReaction reaction) throws Exception {
        int i;
        IAtomContainer clone = this.getCloneStructure(target);
        Vector<Vector<IAtom>> cloneMaps = new Vector<Vector<IAtom>>();
        for (i = 0; i < rMaps.size(); ++i) {
            cloneMaps.add(this.getCloneMapping(target, clone, rMaps.get(i)));
        }
        for (i = 0; i < cloneMaps.size(); ++i) {
            this.applyTransformAtLocation(clone, (Vector)cloneMaps.get(i), reaction);
        }
        AtomConfigurator cfg = new AtomConfigurator();
        cfg.process(clone);
        return clone;
    }

    IAtomContainer getCloneStructure(IAtomContainer target) throws Exception {
        int i;
        AtomContainer mol = new AtomContainer();
        IAtom[] newAtoms = new IAtom[target.getAtomCount()];
        IBond[] newBonds = new IBond[target.getBondCount()];
        for (i = 0; i < target.getAtomCount(); ++i) {
            IAtom a = target.getAtom(i);
            IAtom a1 = this.cloneAtom(a);
            mol.addAtom(a1);
            newAtoms[i] = a1;
        }
        for (i = 0; i < target.getBondCount(); ++i) {
            IBond b = target.getBond(i);
            Bond b1 = new Bond();
            IAtom[] a01 = new IAtom[2];
            int ind0 = target.getAtomNumber(b.getAtom(0));
            int ind1 = target.getAtomNumber(b.getAtom(1));
            a01[0] = mol.getAtom(ind0);
            a01[1] = mol.getAtom(ind1);
            b1.setAtoms(a01);
            b1.setOrder(b.getOrder());
            boolean FlagArom = b.getFlag(5);
            b1.setFlag(5, FlagArom);
            mol.addBond((IBond)b1);
            newBonds[i] = b1;
        }
        return mol;
    }

    IAtom cloneAtom(IAtom a) throws Exception {
        IAtom a1 = (IAtom)a.clone();
        return a1;
    }

    Vector<IAtom> getCloneMapping(IAtomContainer target, IAtomContainer clone, Vector<IAtom> map) {
        Vector<IAtom> cloneMap = new Vector<IAtom>();
        for (int i = 0; i < map.size(); ++i) {
            IAtom at = map.get(i);
            int targetIndex = target.getAtomNumber(at);
            cloneMap.add(clone.getAtom(targetIndex));
        }
        return cloneMap;
    }

    public void printSSMap(IAtomContainer target, Vector<IAtom> rMap) {
        System.out.print("Map: ");
        for (int i = 0; i < rMap.size(); ++i) {
            IAtom tAt = rMap.get(i);
            System.out.print(" " + target.getAtomNumber(tAt));
        }
        System.out.println();
    }

    public void printMappingClusters(Vector<Vector<Integer>> clusterIndexes, IAtomContainer target) {
        for (int i = 0; i < clusterIndexes.size(); ++i) {
            System.out.print("Cluster #" + i + " : ");
            Vector<Integer> v = clusterIndexes.get(i);
            for (int k = 0; k < v.size(); ++k) {
                System.out.print(v.get(k) + " ");
            }
            System.out.println();
        }
    }
}

