/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jmol.api.JmolMeasurementClient;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.TickInfo;
import org.jmol.util.Point3fi;
import org.jmol.viewer.Viewer;

public class MeasurementData
implements JmolMeasurementClient {
    private JmolMeasurementClient client;
    private List measurementStrings;
    private Atom[] atoms;
    public boolean mustBeConnected;
    public boolean mustNotBeConnected;
    public TickInfo tickInfo;
    public int tokAction;
    public List points;
    public float[] rangeMinMax;
    public String strFormat;
    public boolean isAll;
    private String units;
    private Viewer viewer;

    public MeasurementData(List list, int n, float[] fArray, String string, String string2, TickInfo tickInfo, boolean bl, boolean bl2, boolean bl3) {
        this.tokAction = n;
        this.points = list;
        this.rangeMinMax = fArray;
        this.strFormat = string;
        this.units = string2;
        this.tickInfo = tickInfo;
        this.mustBeConnected = bl;
        this.mustNotBeConnected = bl2;
        this.isAll = bl3;
    }

    public void processNextMeasure(Measurement measurement) {
        float f = measurement.getMeasurement();
        if (this.rangeMinMax != null && this.rangeMinMax[0] != Float.MAX_VALUE && (f < this.rangeMinMax[0] || f > this.rangeMinMax[1])) {
            return;
        }
        this.measurementStrings.add(measurement.getString(this.viewer, this.strFormat, this.units));
    }

    public List getMeasurements(Viewer viewer) {
        this.viewer = viewer;
        this.measurementStrings = new ArrayList();
        this.define(null, viewer.getModelSet());
        return this.measurementStrings;
    }

    public void define(JmolMeasurementClient jmolMeasurementClient, ModelSet modelSet) {
        this.client = jmolMeasurementClient == null ? this : jmolMeasurementClient;
        this.atoms = modelSet.atoms;
        int n = this.points.size();
        if (n < 2) {
            return;
        }
        int n2 = -1;
        Point3fi[] point3fiArray = new Point3fi[4];
        int[] nArray = new int[5];
        Measurement measurement = new Measurement(modelSet, nArray, point3fiArray, null);
        measurement.setCount(n);
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            Object e = this.points.get(i);
            if (e instanceof BitSet) {
                BitSet bitSet = (BitSet)e;
                int n4 = bitSet.cardinality();
                if (n4 == 0) {
                    return;
                }
                if (n4 > 1) {
                    n2 = 0;
                }
                n3 = i;
                nArray[i + 1] = bitSet.nextSetBit(0);
                continue;
            }
            if (point3fiArray == null) {
                point3fiArray = new Point3fi[4];
            }
            point3fiArray[i] = (Point3fi)e;
            nArray[i + 1] = -2 - i;
        }
        this.nextMeasure(0, n3, measurement, n2);
    }

    private void nextMeasure(int n, int n2, Measurement measurement, int n3) {
        int n4;
        if (n > n2) {
            if (!(!measurement.isValid() || this.mustBeConnected && !measurement.isConnected(this.atoms, n) || this.mustNotBeConnected && measurement.isConnected(this.atoms, n))) {
                this.client.processNextMeasure(measurement);
            }
            return;
        }
        BitSet bitSet = (BitSet)this.points.get(n);
        int[] nArray = measurement.getCountPlusIndices();
        int n5 = n4 = n == 0 ? Integer.MAX_VALUE : nArray[n];
        if (n4 < 0) {
            this.nextMeasure(n + 1, n2, measurement, n3);
            return;
        }
        boolean bl = false;
        int n6 = bitSet.nextSetBit(0);
        while (n6 >= 0) {
            block8: {
                block9: {
                    int n7;
                    block10: {
                        if (n6 == n4) break block8;
                        n7 = this.atoms[n6].getModelIndex();
                        if (n3 < 0) break block9;
                        if (n != 0) break block10;
                        n3 = n7;
                        break block9;
                    }
                    if (n3 != n7) break block8;
                }
                nArray[n + 1] = n6;
                bl = true;
                this.nextMeasure(n + 1, n2, measurement, n3);
            }
            n6 = bitSet.nextSetBit(n6 + 1);
        }
        if (!bl) {
            this.nextMeasure(n + 1, n2, measurement, n3);
        }
    }
}

