/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.shared.CannotEncodeCharacterException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xerces.util.XMLChar;

public class Util {
    protected static Pattern standardEntities = Pattern.compile("&|<|>|\t|\n|\r|'|\"");
    protected static Pattern entityValueEntities = Pattern.compile("&|%|'|\"");
    protected static Pattern elementContentEntities = Pattern.compile("<|>|&|[\u0000-\u001f&&[^\n\r\t]]|\uffff|\ufffe");

    public static int splitNamespace(String uri) {
        int j;
        char ch;
        int lg = uri.length();
        if (lg == 0) {
            return 0;
        }
        for (int i = lg - 1; i >= 1 && !Util.notNameChar(ch = uri.charAt(i)); --i) {
        }
        for (j = i + 1; j < lg && (!XMLChar.isNCNameStart((int)(ch = uri.charAt(j))) || uri.charAt(j - 1) == ':' && uri.lastIndexOf(58, j - 2) == -1); ++j) {
        }
        return j;
    }

    public static boolean notNameChar(char ch) {
        return !XMLChar.isNCName((int)ch);
    }

    public static String substituteStandardEntities(String s) {
        if (standardEntities.matcher(s).find()) {
            return Util.substituteEntitiesInElementContent(s).replaceAll("'", "&apos;").replaceAll("\t", "&#9;").replaceAll("\n", "&#xA;").replaceAll("\r", "&#xD;").replaceAll("\"", "&quot;");
        }
        return s;
    }

    public static String substituteEntitiesInEntityValue(String s) {
        if (entityValueEntities.matcher(s).find()) {
            return s.replaceAll("&", "&amp;").replaceAll("'", "&apos;").replaceAll("%", "&#37;").replaceAll("\"", "&quot;");
        }
        return s;
    }

    public static String substituteEntitiesInElementContent(String s) {
        Matcher m = elementContentEntities.matcher(s);
        if (!m.find()) {
            return s;
        }
        int start = 0;
        StringBuffer result = new StringBuffer();
        do {
            result.append(s.substring(start, m.start()));
            char ch = s.charAt(m.start());
            switch (ch) {
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                default: {
                    throw new CannotEncodeCharacterException(ch, "XML");
                }
            }
        } while (m.find(start = m.end()));
        result.append(s.substring(start));
        return result.toString();
    }

    public static String replace(String s, String oldString, String newString) {
        String result = "";
        int length = oldString.length();
        int pos = s.indexOf(oldString);
        int lastPos = 0;
        while (pos >= 0) {
            result = result + s.substring(lastPos, pos) + newString;
            lastPos = pos + length;
            pos = s.indexOf(oldString, lastPos);
        }
        return result + s.substring(lastPos, s.length());
    }

    public static String XgetProperty(String p) {
        return Util.XgetProperty(p, null);
    }

    public static String XgetProperty(String p, String def) {
        try {
            return System.getProperty(p, def);
        }
        catch (SecurityException e) {
            return def;
        }
    }
}

