/*
 * Decompiled with CFR 0.152.
 */
package signature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import signature.AbstractGraphBuilder;
import signature.AbstractVertexSignature;
import signature.ColoredTree;
import signature.SymmetryClass;
import signature.VirtualGraphBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraphSignature {
    private final String separator;
    private int height;
    private String graphSignature;

    public AbstractGraphSignature() {
        this(" + ", -1);
    }

    public AbstractGraphSignature(String separator) {
        this(separator, -1);
    }

    public AbstractGraphSignature(int height) {
        this(" + ", height);
    }

    public AbstractGraphSignature(String separator, int height) {
        this.separator = separator;
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    protected abstract int getVertexCount();

    public abstract String signatureStringForVertex(int var1);

    public abstract String signatureStringForVertex(int var1, int var2);

    public abstract AbstractVertexSignature signatureForVertex(int var1);

    public String toCanonicalString() {
        String canonicalString = null;
        int i = 0;
        while (i < this.getVertexCount()) {
            String signatureString = this.signatureStringForVertex(i);
            if (canonicalString == null || canonicalString.compareTo(signatureString) > 0) {
                canonicalString = signatureString;
            }
            ++i;
        }
        if (canonicalString == null) {
            return "";
        }
        return canonicalString;
    }

    public List<SymmetryClass> getSymmetryClasses() {
        return this.getSymmetryClasses(-1);
    }

    public List<SymmetryClass> getSymmetryClasses(int height) {
        ArrayList<SymmetryClass> symmetryClasses = new ArrayList<SymmetryClass>();
        int i = 0;
        while (i < this.getVertexCount()) {
            String signatureString = this.signatureStringForVertex(i, height);
            SymmetryClass foundClass = null;
            for (SymmetryClass symmetryClass : symmetryClasses) {
                if (!symmetryClass.hasSignature(signatureString)) continue;
                foundClass = symmetryClass;
                break;
            }
            if (foundClass == null) {
                foundClass = new SymmetryClass(signatureString);
                symmetryClasses.add(foundClass);
            }
            foundClass.addIndex(i);
            ++i;
        }
        return symmetryClasses;
    }

    public String toFullString() {
        HashMap<String, Integer> sigmap = new HashMap<String, Integer>();
        int i = 0;
        while (i < this.getVertexCount()) {
            String signatureString = this.signatureStringForVertex(i);
            if (sigmap.containsKey(signatureString)) {
                int count = (Integer)sigmap.get(signatureString);
                sigmap.put(signatureString, count + 1);
            } else {
                sigmap.put(signatureString, 1);
            }
            ++i;
        }
        ArrayList keyList = new ArrayList();
        keyList.addAll(sigmap.keySet());
        Collections.sort(keyList);
        StringBuffer buffer = new StringBuffer();
        int i2 = 0;
        while (i2 < keyList.size() - 1) {
            String signature = (String)keyList.get(i2);
            int count = (Integer)sigmap.get(signature);
            buffer.append(count).append(signature).append(this.separator);
            ++i2;
        }
        String finalSignature = (String)keyList.get(keyList.size() - 1);
        int count = (Integer)sigmap.get(finalSignature);
        buffer.append(count).append(finalSignature);
        return buffer.toString();
    }

    public String getGraphSignature() {
        this.graphSignature = this.getMaximalSignature();
        return this.graphSignature;
    }

    public List<String> getSortedSignatures() {
        List<String> vertexSignatures = this.getVertexSignatureStrings();
        Collections.sort(vertexSignatures);
        return vertexSignatures;
    }

    public String getMinimalSignature() {
        List<String> sortedSignatures = this.getSortedSignatures();
        return sortedSignatures.get(sortedSignatures.size() - 1);
    }

    public String getMaximalSignature() {
        List<String> sortedSignatures = this.getSortedSignatures();
        return sortedSignatures.get(0);
    }

    public List<String> getVertexSignatureStrings() {
        ArrayList<String> vertexSignatures = new ArrayList<String>();
        int i = 0;
        while (i < this.getVertexCount()) {
            vertexSignatures.add(this.signatureStringForVertex(i));
            ++i;
        }
        return vertexSignatures;
    }

    public List<AbstractVertexSignature> getVertexSignatures() {
        ArrayList<AbstractVertexSignature> signatures = new ArrayList<AbstractVertexSignature>();
        int i = 0;
        while (i < this.getVertexCount()) {
            signatures.add(this.signatureForVertex(i));
            ++i;
        }
        return signatures;
    }

    public boolean isCanonicallyLabelled() {
        int[] labels = this.getCanonicalLabels();
        int previousLabel = -1;
        int i = 0;
        while (i < labels.length) {
            if (previousLabel != -1 && labels[i] <= previousLabel) {
                return false;
            }
            previousLabel = labels[i];
            ++i;
        }
        return true;
    }

    public void reconstructCanonicalGraph(AbstractVertexSignature signature, AbstractGraphBuilder builder) {
        String canonicalString = this.toCanonicalString();
        ColoredTree tree = AbstractVertexSignature.parse(canonicalString);
        builder.makeFromColoredTree(tree);
    }

    public int[] getCanonicalLabels() {
        int n = this.getVertexCount();
        AbstractVertexSignature canonicalSignature = null;
        String canonicalSignatureString = null;
        int i = 0;
        while (i < n) {
            AbstractVertexSignature signatureForVertexI = this.signatureForVertex(i);
            String signatureString = signatureForVertexI.toCanonicalString();
            if (canonicalSignature == null || signatureString.compareTo(canonicalSignatureString) < 0) {
                canonicalSignature = signatureForVertexI;
                canonicalSignatureString = signatureString;
            }
            ++i;
        }
        return canonicalSignature.getCanonicalLabelling(n);
    }

    public String reconstructCanonicalEdgeString() {
        String canonicalString = this.toCanonicalString();
        VirtualGraphBuilder builder = new VirtualGraphBuilder();
        builder.makeFromColoredTree(AbstractVertexSignature.parse(canonicalString));
        return builder.toEdgeString();
    }
}

