/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.xmlcml.euclid.Axis;
import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.RealRange;
import org.xmlcml.euclid.Transform3;

public class Real3Range
implements EuclidConstants {
    private RealRange[] xyzrange = new RealRange[3];

    public Real3Range() {
        for (int i = 0; i < 3; ++i) {
            this.xyzrange[i] = new RealRange();
        }
    }

    public Real3Range(RealRange xr, RealRange yr, RealRange zr) {
        this.setRanges(xr, yr, zr);
    }

    public void setRanges(RealRange xr, RealRange yr, RealRange zr) {
        this.xyzrange[0] = new RealRange(xr);
        this.xyzrange[1] = new RealRange(yr);
        this.xyzrange[2] = new RealRange(zr);
    }

    public Real3Range(Real3Range r) {
        for (int i = 0; i < 3; ++i) {
            this.xyzrange[i] = new RealRange(r.xyzrange[i]);
        }
    }

    public boolean isEqualTo(Real3Range r3) {
        return this.xyzrange[0].isEqualTo(r3.xyzrange[0]) && this.xyzrange[1].isEqualTo(r3.xyzrange[1]) && this.xyzrange[2].isEqualTo(r3.xyzrange[2]);
    }

    public Real3Range plus(Real3Range r3) {
        return new Real3Range(this.xyzrange[0].plus(r3.xyzrange[0]), this.xyzrange[1].plus(r3.xyzrange[1]), this.xyzrange[2].plus(r3.xyzrange[2]));
    }

    public RealRange getXRange() {
        return this.xyzrange[0];
    }

    public RealRange getYRange() {
        return this.xyzrange[1];
    }

    public RealRange getZRange() {
        return this.xyzrange[2];
    }

    public void add(Axis.Axis3 ax, double value) {
        this.xyzrange[ax.value].add(value);
    }

    public void add(Axis.Axis3 ax, RealRange range) {
        this.xyzrange[ax.value] = range;
    }

    protected void add(int axis, double value) {
        this.xyzrange[axis].add(value);
    }

    public boolean includes(Point3 p) {
        double[] coords = p.getArray();
        return this.xyzrange[0].includes(coords[0]) && this.xyzrange[1].includes(coords[1]) && this.xyzrange[2].includes(coords[2]);
    }

    public void add(Point3 p) {
        double[] coords = p.getArray();
        this.xyzrange[0].add(coords[0]);
        this.xyzrange[1].add(coords[1]);
        this.xyzrange[2].add(coords[2]);
    }

    public Point3 getMinPoint3() {
        return new Point3(this.xyzrange[0].getMin(), this.xyzrange[1].getMin(), this.xyzrange[2].getMin());
    }

    public Point3 getMaxPoint3() {
        return new Point3(this.xyzrange[0].getMax(), this.xyzrange[1].getMax(), this.xyzrange[2].getMax());
    }

    public void transformEquals(Transform3 transform) {
        Point3 minxyz = this.getMinPoint3();
        Point3 maxxyz = this.getMaxPoint3();
        minxyz.transformEquals(transform);
        maxxyz.transformEquals(transform);
        Real3Range newRange3 = new Real3Range();
        newRange3.add(minxyz);
        newRange3.add(maxxyz);
        int i = 0;
        for (RealRange xyzr : newRange3.xyzrange) {
            this.xyzrange[i++] = new RealRange(xyzr);
        }
    }

    public String toString() {
        return "(" + this.xyzrange[0] + "," + this.xyzrange[1] + "," + this.xyzrange[2] + ")";
    }
}

