/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.listener;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.ReaderEvent;
import org.openscience.cdk.io.listener.IReaderListener;
import org.openscience.cdk.io.listener.IWriterListener;
import org.openscience.cdk.io.setting.IOSetting;

public class PropertiesListener
implements IReaderListener,
IWriterListener {
    private Properties props;
    private PrintWriter out;

    public PropertiesListener(Properties props) {
        this.props = props;
        this.setOutputWriter(new OutputStreamWriter(System.out));
    }

    public void setOutputWriter(Writer writer) {
        this.out = writer instanceof PrintWriter ? (PrintWriter)writer : (writer == null ? null : new PrintWriter(writer));
    }

    public void frameRead(ReaderEvent event) {
    }

    public void processIOSettingQuestion(IOSetting setting) {
        String questionName = setting.getName();
        if (this.props != null) {
            String propValue = this.props.getProperty(questionName, setting.getSetting());
            try {
                setting.setSetting(propValue);
            }
            catch (CDKException exception) {
                String message = "Submitted Value (" + propValue + ") is not valid!";
                this.out.println(message);
            }
        }
    }
}

