/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.chemistry;

import com.rapidminer.tools.PaDELSimpleTable;
import java.util.ArrayList;
import libpadeldescriptor.CDK_AtomCountDescriptor;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMoleculeSet;

public class Compounds
extends PaDELSimpleTable {
    private static final long serialVersionUID = 3621893012632345833L;
    private ArrayList<IAtomContainer> mols = new ArrayList();

    public Compounds() {
        super("Molecules", new String[]{"Compound", "nAtoms", "nBonds", "nFragments", "nHydrogens"});
    }

    public int size() {
        return this.mols.size();
    }

    public void addMolecule(IAtomContainer iAtomContainer) {
        this.mols.add(iAtomContainer);
        this.addRow(String.valueOf(this.mols.size()), new String[]{(String)iAtomContainer.getProperty((Object)"cdk:Title"), "", "", "", ""});
        this.calculateStatistics(iAtomContainer, this.mols.size() - 1);
    }

    public void recalculateStatistics() {
        int n = this.mols.size();
        for (int i = 0; i < n; ++i) {
            this.calculateStatistics(this.mols.get(i), i);
        }
    }

    public void calculateStatistics(IAtomContainer iAtomContainer, int n) {
        IMoleculeSet iMoleculeSet;
        String string = (String)iAtomContainer.getProperty((Object)"cdk:Title");
        String string2 = String.valueOf(iAtomContainer.getAtomCount());
        String string3 = String.valueOf(iAtomContainer.getBondCount());
        String string4 = "1";
        if (!ConnectivityChecker.isConnected((IAtomContainer)iAtomContainer)) {
            iMoleculeSet = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)iAtomContainer);
            string4 = String.valueOf(iMoleculeSet.getMoleculeCount());
        }
        iMoleculeSet = new CDK_AtomCountDescriptor((Object[])new String[]{"H"});
        iMoleculeSet.setMolecule(iAtomContainer);
        iMoleculeSet.run();
        String string5 = String.valueOf(iMoleculeSet.getDescriptorValues()[0]);
        this.setValue(n, 0, string);
        this.setValue(n, 1, string2);
        this.setValue(n, 2, string3);
        this.setValue(n, 3, string4);
        this.setValue(n, 4, string5);
    }

    public ArrayList<IAtomContainer> getMolecules() {
        ArrayList<IAtomContainer> arrayList = new ArrayList<IAtomContainer>(this.mols.size());
        int n = this.mols.size();
        for (int i = 0; i < n; ++i) {
            try {
                arrayList.add(this.mols.get(i).clone());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public IAtomContainer getMolecule(int n) {
        return this.mols.get(n);
    }

    public void setMolecule(int n, IAtomContainer iAtomContainer) {
        this.mols.set(n, iAtomContainer);
        this.calculateStatistics(iAtomContainer, n);
    }

    public String getMoleculeName(int n) {
        return (String)this.mols.get(n).getProperty((Object)"cdk:Title");
    }

    public void setMoleculeName(int n, String string) {
        this.mols.get(n).setProperty((Object)"cdk:Title", (Object)string);
    }
}

