/*
 * Decompiled with CFR 0.152.
 */
package padeldescriptor;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;
import libpadeldescriptor.DescriptorStruct;
import libpadeldescriptor.libPaDELDescriptorType;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;
import padeldescriptor.PaDELDescriptorAboutBox;
import padeldescriptor.PaDELDescriptorApp;
import padeldescriptor.PaDELDescriptorPropertySheetPage1;
import padeldescriptor.PaDELDescriptorPropertySheetPage2;
import padeldescriptor.PaDELDescriptorPropertySheetPage3;
import padeldescriptor.PaDELDescriptorPropertySheetPage4;

public class PaDELDescriptorView
extends FrameView {
    private JMenuItem LoadConfig;
    private JMenuItem SaveConfig;
    public PaDELDescriptorPropertySheetPage1 config;
    public PaDELDescriptorPropertySheetPage2 descriptor2DConfig;
    public PaDELDescriptorPropertySheetPage3 descriptor3DConfig;
    public PaDELDescriptorPropertySheetPage4 fingerprintConfig;
    private JTabbedPane jTabbedPane1;
    private JMenuItem loadDescriptors;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    public JProgressBar progressBar;
    private JMenuItem saveDescriptors;
    public JButton start;
    public JLabel status;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    public String descriptorTypeFile = null;
    private JDialog aboutBox;

    public PaDELDescriptorView(SingleFrameApplication singleFrameApplication) {
        super(singleFrameApplication);
        this.initComponents();
        this.LoadConfiguration("PaDEL-Descriptor.ini");
        this.LoadDescriptorTypes("descriptors.xml", true);
        Image image = Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("padeldescriptor/resources/PaDELlogo.jpg"));
        this.getFrame().setIconImage(image);
        ResourceMap resourceMap = this.getResourceMap();
        int n = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(n, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PaDELDescriptorView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int n2 = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(n2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PaDELDescriptorView.this.busyIconIndex = (PaDELDescriptorView.this.busyIconIndex + 1) % PaDELDescriptorView.this.busyIcons.length;
                PaDELDescriptorView.this.statusAnimationLabel.setIcon(PaDELDescriptorView.this.busyIcons[PaDELDescriptorView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("started".equals(string)) {
                    if (!PaDELDescriptorView.this.busyIconTimer.isRunning()) {
                        PaDELDescriptorView.this.statusAnimationLabel.setIcon(PaDELDescriptorView.this.busyIcons[0]);
                        PaDELDescriptorView.this.busyIconIndex = 0;
                        PaDELDescriptorView.this.busyIconTimer.start();
                    }
                    PaDELDescriptorView.this.progressBar.setVisible(true);
                    PaDELDescriptorView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(string)) {
                    PaDELDescriptorView.this.busyIconTimer.stop();
                    PaDELDescriptorView.this.statusAnimationLabel.setIcon(PaDELDescriptorView.this.idleIcon);
                    PaDELDescriptorView.this.progressBar.setVisible(false);
                    PaDELDescriptorView.this.progressBar.setValue(0);
                } else if ("message".equals(string)) {
                    String string2 = (String)propertyChangeEvent.getNewValue();
                    PaDELDescriptorView.this.statusMessageLabel.setText(string2 == null ? "" : string2);
                    PaDELDescriptorView.this.messageTimer.restart();
                } else if ("progress".equals(string)) {
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    PaDELDescriptorView.this.progressBar.setVisible(true);
                    PaDELDescriptorView.this.progressBar.setIndeterminate(false);
                    PaDELDescriptorView.this.progressBar.setValue(n);
                }
            }
        });
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame jFrame = PaDELDescriptorApp.getApplication().getMainFrame();
            this.aboutBox = new PaDELDescriptorAboutBox(jFrame);
            this.aboutBox.setLocationRelativeTo(jFrame);
        }
        PaDELDescriptorApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.start = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.config = new PaDELDescriptorPropertySheetPage1();
        this.descriptor2DConfig = new PaDELDescriptorPropertySheetPage2();
        this.descriptor3DConfig = new PaDELDescriptorPropertySheetPage3();
        this.fingerprintConfig = new PaDELDescriptorPropertySheetPage4();
        this.menuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        this.LoadConfig = new JMenuItem();
        this.SaveConfig = new JMenuItem();
        this.loadDescriptors = new JMenuItem();
        this.saveDescriptors = new JMenuItem();
        JMenuItem jMenuItem = new JMenuItem();
        JMenu jMenu2 = new JMenu();
        JMenuItem jMenuItem2 = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator jSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.status = new JLabel();
        this.mainPanel.setName("mainPanel");
        ApplicationActionMap applicationActionMap = Application.getInstance(PaDELDescriptorApp.class).getContext().getActionMap(PaDELDescriptorView.class, this);
        this.start.setAction(applicationActionMap.get("Start"));
        ResourceMap resourceMap = Application.getInstance(PaDELDescriptorApp.class).getContext().getResourceMap(PaDELDescriptorView.class);
        this.start.setText(resourceMap.getString("start.text", new Object[0]));
        this.start.setToolTipText(resourceMap.getString("start.toolTipText", new Object[0]));
        this.start.setName("start");
        this.jTabbedPane1.setName("jTabbedPane1");
        this.config.setMinimumSize(new Dimension(1, 1));
        this.config.setName("config");
        this.jTabbedPane1.addTab(resourceMap.getString("config.TabConstraints.tabTitle", new Object[0]), this.config);
        this.descriptor2DConfig.setName("descriptor2DConfig");
        this.jTabbedPane1.addTab(resourceMap.getString("descriptor2DConfig.TabConstraints.tabTitle", new Object[0]), this.descriptor2DConfig);
        this.descriptor3DConfig.setName("descriptor3DConfig");
        this.jTabbedPane1.addTab(resourceMap.getString("descriptor3DConfig.TabConstraints.tabTitle", new Object[0]), this.descriptor3DConfig);
        this.fingerprintConfig.setName("fingerprintConfig");
        this.jTabbedPane1.addTab(resourceMap.getString("fingerprintConfig.TabConstraints.tabTitle", new Object[0]), this.fingerprintConfig);
        GroupLayout groupLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(525, Short.MAX_VALUE).addComponent(this.start).addContainerGap()).addComponent(this.jTabbedPane1, -1, 592, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jTabbedPane1, -2, 375, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.start).addContainerGap()));
        this.menuBar.setName("menuBar");
        jMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        jMenu.setName("fileMenu");
        this.LoadConfig.setAction(applicationActionMap.get("LoadConfig"));
        this.LoadConfig.setText(resourceMap.getString("LoadConfig.text", new Object[0]));
        this.LoadConfig.setName("LoadConfig");
        jMenu.add(this.LoadConfig);
        this.SaveConfig.setAction(applicationActionMap.get("SaveConfig"));
        this.SaveConfig.setText(resourceMap.getString("SaveConfig.text", new Object[0]));
        this.SaveConfig.setName("SaveConfig");
        jMenu.add(this.SaveConfig);
        this.loadDescriptors.setAction(applicationActionMap.get("BrowseDescriptorTypes"));
        this.loadDescriptors.setText(resourceMap.getString("loadDescriptors.text", new Object[0]));
        this.loadDescriptors.setName("loadDescriptors");
        jMenu.add(this.loadDescriptors);
        this.saveDescriptors.setAction(applicationActionMap.get("SaveDescriptorTypes"));
        this.saveDescriptors.setText(resourceMap.getString("saveDescriptors.text", new Object[0]));
        this.saveDescriptors.setName("saveDescriptors");
        jMenu.add(this.saveDescriptors);
        jMenuItem.setAction(applicationActionMap.get("quit"));
        jMenuItem.setName("exitMenuItem");
        jMenu.add(jMenuItem);
        this.menuBar.add(jMenu);
        jMenu2.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        jMenu2.setName("helpMenu");
        jMenuItem2.setAction(applicationActionMap.get("showAboutBox"));
        jMenuItem2.setName("aboutMenuItem");
        jMenu2.add(jMenuItem2);
        this.menuBar.add(jMenu2);
        this.statusPanel.setName("statusPanel");
        jSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        this.status.setText(resourceMap.getString("status.text", new Object[0]));
        this.status.setVerticalAlignment(1);
        this.status.setName("status");
        GroupLayout groupLayout2 = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jSeparator, -1, 592, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.progressBar, -2, -1, -2).addComponent(this.status, GroupLayout.Alignment.LEADING, -1, 566, Short.MAX_VALUE).addComponent(this.statusMessageLabel, GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(jSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.status, -1, 115, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel)).addComponent(this.progressBar, -2, -1, -2)).addContainerGap()));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    protected void LoadConfiguration(String string) {
        try {
            Properties properties = new Properties();
            if (new File(string).exists()) {
                FileInputStream fileInputStream = new FileInputStream(string);
                properties.load(fileInputStream);
                this.config.data.setDirectory(properties.getProperty("Directory"));
                this.config.data.setDescriptorFile(properties.getProperty("DescriptorFile"));
                this.config.data.setCompute2D(Boolean.valueOf(properties.getProperty("Compute2D")));
                this.config.data.setCompute3D(Boolean.valueOf(properties.getProperty("Compute3D")));
                this.config.data.setComputeFingerprints(Boolean.valueOf(properties.getProperty("ComputeFingerprints")));
                this.config.data.setRemoveSalt(Boolean.valueOf(properties.getProperty("RemoveSalt")));
                this.config.data.setDetectAromaticity(Boolean.valueOf(properties.getProperty("DetectAromaticity")));
                this.config.data.setStandardizeTautomers(Boolean.valueOf(properties.getProperty("StandardizeTautomers")));
                this.config.data.setTautomerFile(properties.getProperty("TautomerFile"));
                this.config.data.setStandardizeNitro(Boolean.valueOf(properties.getProperty("StandardizeNitro")));
                this.config.data.setRetain3D(Boolean.valueOf(properties.getProperty("Retain3D")));
                this.config.data.setConvert3D(properties.getProperty("Convert3D"));
                this.config.data.setLog(Boolean.valueOf(properties.getProperty("Log")));
                this.config.data.setMaxThreads(Integer.valueOf(properties.getProperty("MaxThreads")));
                this.config.data.setMaxJobsWaiting(Integer.valueOf(properties.getProperty("MaxJobsWaiting")));
                this.config.data.setMaxRunTime(Long.valueOf(properties.getProperty("MaxRunTime")));
                this.config.data.setMaxCpdPerFile(Integer.valueOf(properties.getProperty("MaxCpdPerFile")));
                this.config.data.setRetainOrder(Boolean.valueOf(properties.getProperty("RetainOrder")));
                this.config.data.setUseFilenameAsMolName(Boolean.valueOf(properties.getProperty("UseFilenameAsMolName")));
                this.config.sheet.readFromObject((Object)this.config.data);
                fileInputStream.close();
            }
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.FINE, "Cannot load configuration", exception);
        }
    }

    protected void SaveConfiguration(String string) {
        try {
            Properties properties = new Properties();
            properties.setProperty("Directory", this.config.data.getDirectory());
            properties.setProperty("DescriptorFile", this.config.data.getDescriptorFile());
            properties.setProperty("Compute2D", Boolean.toString(this.config.data.isCompute2D()));
            properties.setProperty("Compute3D", Boolean.toString(this.config.data.isCompute3D()));
            properties.setProperty("ComputeFingerprints", Boolean.toString(this.config.data.isComputeFingerprints()));
            properties.setProperty("RemoveSalt", Boolean.toString(this.config.data.isRemoveSalt()));
            properties.setProperty("DetectAromaticity", Boolean.toString(this.config.data.isDetectAromaticity()));
            properties.setProperty("StandardizeTautomers", Boolean.toString(this.config.data.isStandardizeTautomers()));
            properties.setProperty("TautomerFile", this.config.data.getTautomerFile());
            properties.setProperty("StandardizeNitro", Boolean.toString(this.config.data.isStandardizeNitro()));
            properties.setProperty("Retain3D", Boolean.toString(this.config.data.isRetain3D()));
            properties.setProperty("Convert3D", this.config.data.getConvert3D());
            properties.setProperty("Log", Boolean.toString(this.config.data.isLog()));
            properties.setProperty("MaxThreads", Integer.toString(this.config.data.getMaxThreads()));
            properties.setProperty("MaxJobsWaiting", Integer.toString(this.config.data.getMaxJobsWaiting()));
            properties.setProperty("MaxRunTime", Long.toString(this.config.data.getMaxRunTime()));
            properties.setProperty("MaxCpdPerFile", Integer.toString(this.config.data.getMaxCpdPerFile()));
            properties.setProperty("RetainOrder", Boolean.toString(this.config.data.isRetainOrder()));
            properties.setProperty("UseFilenameAsMolName", Boolean.toString(this.config.data.isUseFilenameAsMolName()));
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            properties.store(fileOutputStream, null);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.FINE, "Cannot save configuration", exception);
        }
    }

    protected void LoadDescriptorTypes(String string, boolean bl) {
        Set set = libPaDELDescriptorType.GetDescriptorTypes((String)string);
        if (set == null && bl) {
            set = libPaDELDescriptorType.GetDescriptorTypes((InputStream)this.getClass().getClassLoader().getResourceAsStream("META-INF/descriptors.xml"));
        }
        if (set == null) {
            return;
        }
        Method method = null;
        Class[] classArray = new Class[]{Boolean.TYPE};
        for (DescriptorStruct descriptorStruct : set) {
            try {
                method = this.descriptor2DConfig.data.getClass().getMethod("set" + descriptorStruct.getName(), classArray);
                if (method == null) continue;
                method.invoke((Object)this.descriptor2DConfig.data, descriptorStruct.isActive());
                this.descriptor2DConfig.sheet.readFromObject((Object)this.descriptor2DConfig.data);
            }
            catch (Exception exception) {
                try {
                    method = this.descriptor3DConfig.data.getClass().getMethod("set" + descriptorStruct.getName(), classArray);
                    if (method == null) continue;
                    method.invoke((Object)this.descriptor3DConfig.data, descriptorStruct.isActive());
                    this.descriptor3DConfig.sheet.readFromObject((Object)this.descriptor3DConfig.data);
                }
                catch (Exception exception2) {
                    try {
                        method = this.fingerprintConfig.data.getClass().getMethod("set" + descriptorStruct.getName(), classArray);
                        if (method == null) continue;
                        method.invoke((Object)this.fingerprintConfig.data, descriptorStruct.isActive());
                        this.fingerprintConfig.sheet.readFromObject((Object)this.fingerprintConfig.data);
                    }
                    catch (Exception exception3) {
                        Logger.getLogger(PaDELDescriptorView.class.getName()).log(Level.SEVERE, "Cannot find descriptor type.", exception3);
                    }
                }
            }
        }
    }

    protected void SaveDescriptorTypes(String string) {
        libPaDELDescriptorType.SaveDescriptorTypes((String)string, this.GetDescriptors());
    }

    public Set<DescriptorStruct> GetDescriptors() {
        return PaDELDescriptorView.GetDescriptors(this.descriptor2DConfig, this.descriptor3DConfig, this.fingerprintConfig);
    }

    public static Set<DescriptorStruct> GetDescriptors(PaDELDescriptorPropertySheetPage2 paDELDescriptorPropertySheetPage2, PaDELDescriptorPropertySheetPage3 paDELDescriptorPropertySheetPage3, PaDELDescriptorPropertySheetPage4 paDELDescriptorPropertySheetPage4) {
        LinkedHashSet<DescriptorStruct> linkedHashSet = new LinkedHashSet<DescriptorStruct>();
        linkedHashSet.add(new DescriptorStruct("AcidicGroupCount", "2D", paDELDescriptorPropertySheetPage2.data.isAcidicGroupCount()));
        linkedHashSet.add(new DescriptorStruct("ALOGP", "2D", paDELDescriptorPropertySheetPage2.data.isALOGP()));
        linkedHashSet.add(new DescriptorStruct("AminoAcidCount", "2D", paDELDescriptorPropertySheetPage2.data.isAminoAcidCount()));
        linkedHashSet.add(new DescriptorStruct("APol", "2D", paDELDescriptorPropertySheetPage2.data.isAPol()));
        linkedHashSet.add(new DescriptorStruct("AromaticAtomsCount", "2D", paDELDescriptorPropertySheetPage2.data.isAromaticAtomsCount()));
        linkedHashSet.add(new DescriptorStruct("AromaticBondsCount", "2D", paDELDescriptorPropertySheetPage2.data.isAromaticBondsCount()));
        linkedHashSet.add(new DescriptorStruct("AtomCount", "2D", paDELDescriptorPropertySheetPage2.data.isAtomCount()));
        linkedHashSet.add(new DescriptorStruct("AutocorrelationCharge", "2D", paDELDescriptorPropertySheetPage2.data.isAutocorrelationCharge()));
        linkedHashSet.add(new DescriptorStruct("AutocorrelationMass", "2D", paDELDescriptorPropertySheetPage2.data.isAutocorrelationMass()));
        linkedHashSet.add(new DescriptorStruct("AutocorrelationPolarizability", "2D", paDELDescriptorPropertySheetPage2.data.isAutocorrelationPolarizability()));
        linkedHashSet.add(new DescriptorStruct("BasicGroupCount", "2D", paDELDescriptorPropertySheetPage2.data.isBasicGroupCount()));
        linkedHashSet.add(new DescriptorStruct("BCUT", "2D", paDELDescriptorPropertySheetPage2.data.isBCUT()));
        linkedHashSet.add(new DescriptorStruct("BondCount", "2D", paDELDescriptorPropertySheetPage2.data.isBondCount()));
        linkedHashSet.add(new DescriptorStruct("BPol", "2D", paDELDescriptorPropertySheetPage2.data.isBPol()));
        linkedHashSet.add(new DescriptorStruct("CarbonTypes", "2D", paDELDescriptorPropertySheetPage2.data.isCarbonTypes()));
        linkedHashSet.add(new DescriptorStruct("ChiChain", "2D", paDELDescriptorPropertySheetPage2.data.isChiChain()));
        linkedHashSet.add(new DescriptorStruct("ChiCluster", "2D", paDELDescriptorPropertySheetPage2.data.isChiCluster()));
        linkedHashSet.add(new DescriptorStruct("ChiPathCluster", "2D", paDELDescriptorPropertySheetPage2.data.isChiPathCluster()));
        linkedHashSet.add(new DescriptorStruct("ChiPath", "2D", paDELDescriptorPropertySheetPage2.data.isChiPath()));
        linkedHashSet.add(new DescriptorStruct("Crippen", "2D", paDELDescriptorPropertySheetPage2.data.isCrippen()));
        linkedHashSet.add(new DescriptorStruct("EccentricConnectivityIndex", "2D", paDELDescriptorPropertySheetPage2.data.isEccentricConnectivityIndex()));
        linkedHashSet.add(new DescriptorStruct("EStateAtomType", "2D", paDELDescriptorPropertySheetPage2.data.isEStateAtomType()));
        linkedHashSet.add(new DescriptorStruct("ExtendedTopochemicalAtom", "2D", paDELDescriptorPropertySheetPage2.data.isExtendedTopochemicalAtom()));
        linkedHashSet.add(new DescriptorStruct("FMF", "2D", paDELDescriptorPropertySheetPage2.data.isFMF()));
        linkedHashSet.add(new DescriptorStruct("FragmentComplexity", "2D", paDELDescriptorPropertySheetPage2.data.isFragmentComplexity()));
        linkedHashSet.add(new DescriptorStruct("HBondAcceptorCount", "2D", paDELDescriptorPropertySheetPage2.data.isHBondAcceptorCount()));
        linkedHashSet.add(new DescriptorStruct("HBondDonorCount", "2D", paDELDescriptorPropertySheetPage2.data.isHBondDonorCount()));
        linkedHashSet.add(new DescriptorStruct("HybridizationRatio", "2D", paDELDescriptorPropertySheetPage2.data.isHybridizationRatio()));
        linkedHashSet.add(new DescriptorStruct("IPMolecularLearning", "2D", paDELDescriptorPropertySheetPage2.data.isIPMolecularLearning()));
        linkedHashSet.add(new DescriptorStruct("KappaShapeIndices", "2D", paDELDescriptorPropertySheetPage2.data.isKappaShapeIndices()));
        linkedHashSet.add(new DescriptorStruct("KierHallSmarts", "2D", paDELDescriptorPropertySheetPage2.data.isKierHallSmarts()));
        linkedHashSet.add(new DescriptorStruct("LargestChain", "2D", paDELDescriptorPropertySheetPage2.data.isLargestChain()));
        linkedHashSet.add(new DescriptorStruct("LargestPiSystem", "2D", paDELDescriptorPropertySheetPage2.data.isLargestPiSystem()));
        linkedHashSet.add(new DescriptorStruct("LongestAliphaticChain", "2D", paDELDescriptorPropertySheetPage2.data.isLongestAliphaticChain()));
        linkedHashSet.add(new DescriptorStruct("MannholdLogP", "2D", paDELDescriptorPropertySheetPage2.data.isMannholdLogP()));
        linkedHashSet.add(new DescriptorStruct("McGowanVolume", "2D", paDELDescriptorPropertySheetPage2.data.isMcGowanVolume()));
        linkedHashSet.add(new DescriptorStruct("MDE", "2D", paDELDescriptorPropertySheetPage2.data.isMDE()));
        linkedHashSet.add(new DescriptorStruct("MLFER", "2D", paDELDescriptorPropertySheetPage2.data.isMLFER()));
        linkedHashSet.add(new DescriptorStruct("PetitjeanNumber", "2D", paDELDescriptorPropertySheetPage2.data.isPetitjeanNumber()));
        linkedHashSet.add(new DescriptorStruct("RingCount", "2D", paDELDescriptorPropertySheetPage2.data.isRingCount()));
        linkedHashSet.add(new DescriptorStruct("RotatableBondsCount", "2D", paDELDescriptorPropertySheetPage2.data.isRotatableBondsCount()));
        linkedHashSet.add(new DescriptorStruct("RuleOfFive", "2D", paDELDescriptorPropertySheetPage2.data.isRuleOfFive()));
        linkedHashSet.add(new DescriptorStruct("Topological", "2D", paDELDescriptorPropertySheetPage2.data.isTopological()));
        linkedHashSet.add(new DescriptorStruct("TPSA", "2D", paDELDescriptorPropertySheetPage2.data.isTPSA()));
        linkedHashSet.add(new DescriptorStruct("VABC", "2D", paDELDescriptorPropertySheetPage2.data.isVABC()));
        linkedHashSet.add(new DescriptorStruct("VAdjMa", "2D", paDELDescriptorPropertySheetPage2.data.isVAdjMa()));
        linkedHashSet.add(new DescriptorStruct("Weight", "2D", paDELDescriptorPropertySheetPage2.data.isWeight()));
        linkedHashSet.add(new DescriptorStruct("WeightedPath", "2D", paDELDescriptorPropertySheetPage2.data.isWeightedPath()));
        linkedHashSet.add(new DescriptorStruct("WienerNumbers", "2D", paDELDescriptorPropertySheetPage2.data.isWienerNumbers()));
        linkedHashSet.add(new DescriptorStruct("XLogP", "2D", paDELDescriptorPropertySheetPage2.data.isXLogP()));
        linkedHashSet.add(new DescriptorStruct("ZagrebIndex", "2D", paDELDescriptorPropertySheetPage2.data.isZagrebIndex()));
        linkedHashSet.add(new DescriptorStruct("CPSA", "3D", paDELDescriptorPropertySheetPage3.data.isCPSA()));
        linkedHashSet.add(new DescriptorStruct("GravitationalIndex", "3D", paDELDescriptorPropertySheetPage3.data.isGravitationalIndex()));
        linkedHashSet.add(new DescriptorStruct("LengthOverBreadth", "3D", paDELDescriptorPropertySheetPage3.data.isLengthOverBreadth()));
        linkedHashSet.add(new DescriptorStruct("MomentOfInertia", "3D", paDELDescriptorPropertySheetPage3.data.isMomentOfInertia()));
        linkedHashSet.add(new DescriptorStruct("PetitjeanShapeIndex", "3D", paDELDescriptorPropertySheetPage3.data.isPetitjeanShapeIndex()));
        linkedHashSet.add(new DescriptorStruct("WHIMUnity", "3D", paDELDescriptorPropertySheetPage3.data.isWHIMUnity()));
        linkedHashSet.add(new DescriptorStruct("WHIMMass", "3D", paDELDescriptorPropertySheetPage3.data.isWHIMMass()));
        linkedHashSet.add(new DescriptorStruct("WHIMVolume", "3D", paDELDescriptorPropertySheetPage3.data.isWHIMVolume()));
        linkedHashSet.add(new DescriptorStruct("WHIMEneg", "3D", paDELDescriptorPropertySheetPage3.data.isWHIMEneg()));
        linkedHashSet.add(new DescriptorStruct("WHIMPolar", "3D", paDELDescriptorPropertySheetPage3.data.isWHIMPolar()));
        linkedHashSet.add(new DescriptorStruct("Fingerprinter", "Fingerprint", paDELDescriptorPropertySheetPage4.data.isFingerprinter()));
        linkedHashSet.add(new DescriptorStruct("ExtendedFingerprinter", "Fingerprint", paDELDescriptorPropertySheetPage4.data.isExtendedFingerprinter()));
        linkedHashSet.add(new DescriptorStruct("EStateFingerprinter", "Fingerprint", paDELDescriptorPropertySheetPage4.data.isEStateFingerprinter()));
        linkedHashSet.add(new DescriptorStruct("GraphOnlyFingerprinter", "Fingerprint", paDELDescriptorPropertySheetPage4.data.isGraphOnlyFingerprinter()));
        linkedHashSet.add(new DescriptorStruct("MACCSFingerprinter", "Fingerprint", paDELDescriptorPropertySheetPage4.data.isMACCSFingerprinter()));
        linkedHashSet.add(new DescriptorStruct("PubchemFingerprinter", "Fingerprint", paDELDescriptorPropertySheetPage4.data.isPubchemFingerprinter()));
        linkedHashSet.add(new DescriptorStruct("SubstructureFingerprinter", "Fingerprint", paDELDescriptorPropertySheetPage4.data.isSubstructureFingerprinter()));
        linkedHashSet.add(new DescriptorStruct("SubstructureFingerprintCount", "Fingerprint", paDELDescriptorPropertySheetPage4.data.isSubstructureFingerprintCount()));
        linkedHashSet.add(new DescriptorStruct("KlekotaRothFingerprinter", "Fingerprint", paDELDescriptorPropertySheetPage4.data.isKlekotaRothFingerprinter()));
        linkedHashSet.add(new DescriptorStruct("KlekotaRothFingerprintCount", "Fingerprint", paDELDescriptorPropertySheetPage4.data.isKlekotaRothFingerprintCount()));
        return linkedHashSet;
    }

    @Action
    public void LoadConfig() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File("."));
        jFileChooser.setDialogTitle("Select configuration file");
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (jFileChooser.showOpenDialog(null) == 0) {
            File file = new File(jFileChooser.getSelectedFile().getAbsolutePath());
            if (file.exists()) {
                this.LoadConfiguration(jFileChooser.getSelectedFile().getAbsolutePath());
                JOptionPane.showMessageDialog(null, "Configuration loaded", "Loaded", 1);
            } else {
                JOptionPane.showMessageDialog(null, "File does not exists", "Error", 0);
            }
        }
    }

    @Action
    public void SaveConfig() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File("."));
        jFileChooser.setDialogTitle("Select configuration file");
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (jFileChooser.showSaveDialog(null) == 0) {
            File file = new File(jFileChooser.getSelectedFile().getAbsolutePath());
            if (file.exists()) {
                int n = JOptionPane.showConfirmDialog(null, "File exists. Overwrite file?", "File exists", 0, 2);
                if (n == 0) {
                    this.SaveConfiguration(jFileChooser.getSelectedFile().getAbsolutePath());
                }
            } else {
                this.SaveConfiguration(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    @Action
    public void BrowseDescriptorTypes() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File("."));
        jFileChooser.setDialogTitle("Select descriptor type file");
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("XML file", "xml"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (jFileChooser.showOpenDialog(null) == 0) {
            File file = new File(jFileChooser.getSelectedFile().getAbsolutePath());
            if (file.exists()) {
                this.LoadDescriptorTypes(jFileChooser.getSelectedFile().getAbsolutePath(), false);
                JOptionPane.showMessageDialog(null, "New descriptor types loaded", "Loaded", 1);
            } else {
                JOptionPane.showMessageDialog(null, "File does not exists", "Error", 0);
            }
        }
    }

    @Action
    public void SaveDescriptorTypes() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File("."));
        jFileChooser.setDialogTitle("Select configuration file");
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("XML file", "xml"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (jFileChooser.showSaveDialog(null) == 0) {
            File file;
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            if (!string.endsWith(".xml")) {
                string = string + ".xml";
            }
            if ((file = new File(string)).exists()) {
                int n = JOptionPane.showConfirmDialog(null, "File exists. Overwrite file?", "File exists", 0, 2);
                if (n == 0) {
                    this.SaveDescriptorTypes(string);
                }
            } else {
                this.SaveDescriptorTypes(string);
            }
        }
    }
}

