/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.graph.matrix.AdjacencyMatrix;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class TopologicalDescriptor
implements IMolecularDescriptor {
    public static final String[] names = new String[]{"topoRadius", "topoDiameter", "topoShape", "globalTopoChargeIndex"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("topoDistance", this.getClass().getName(), "$Id: TopologicalDescriptor.java 1 2013-05-31 14:29:01Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        int n = this.getDescriptorNames().length;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayResult.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), exception);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        int n;
        int n2;
        int n3;
        int n4;
        IAtomContainer iAtomContainer2 = AtomContainerManipulator.removeHydrogens(iAtomContainer);
        int n5 = iAtomContainer2.getAtomCount();
        int[][] nArray = AdjacencyMatrix.getMatrix(iAtomContainer2);
        int[][] nArray2 = PathTools.computeFloydAPSP(nArray);
        int[] nArray3 = new int[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = -99999;
            for (int i = 0; i < n5; ++i) {
                if (nArray2[n4][i] <= n3) continue;
                n3 = nArray2[n4][i];
            }
            nArray3[n4] = n3;
        }
        n4 = 999999;
        n3 = -999999;
        for (int n6 : nArray3) {
            if (n6 < n4) {
                n4 = n6;
            }
            if (n6 <= n3) continue;
            n3 = n6;
        }
        double d = (double)(n3 - n4) / (double)n4;
        double[][] dArray = new double[n5][n5];
        for (int n6 = 0; n6 < n5; ++n6) {
            IAtom iAtom = iAtomContainer2.getAtom(n6);
            n2 = n6;
            List<IAtom> list = iAtomContainer2.getConnectedAtomsList(iAtom);
            for (IAtom iAtom2 : list) {
                n = iAtomContainer2.getAtomNumber(iAtom2);
                dArray[n2][n] = 1.0;
                dArray[n][n2] = 1.0;
            }
        }
        double[][] dArray2 = new double[nArray2.length][nArray2[0].length];
        for (int i = 0; i < nArray2.length; ++i) {
            for (n2 = 0; n2 < nArray2[i].length; ++n2) {
                double d2 = nArray2[i][n2];
                dArray2[i][n2] = d2 != 0.0 ? 1.0 / (d2 * d2) : 0.0;
            }
        }
        double[][] dArray3 = new double[nArray2.length][nArray2[0].length];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (int i = 0; i < dArray2[0].length; ++i) {
                for (int j = 0; j < dArray[0].length; ++j) {
                    double[] dArray4 = dArray3[n2];
                    int n7 = i;
                    dArray4[n7] = dArray4[n7] + dArray[n2][j] * dArray2[j][i];
                }
            }
        }
        double[][] dArray5 = new double[n5][n5];
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n5; ++j) {
                dArray5[i][j] = dArray3[i][j] - dArray3[j][i];
                if (i != j) continue;
                dArray5[i][j] = iAtomContainer2.getConnectedAtomsCount(iAtomContainer2.getAtom(i));
            }
        }
        double[] dArray6 = new double[n5];
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n5; ++j) {
                for (n = 0; n < n5; ++n) {
                    double d3 = dArray5[j][n];
                    if (d3 < 0.0) {
                        d3 *= -1.0;
                    }
                    double d4 = 0.0;
                    if (i == nArray2[j][n]) {
                        d4 = 1.0;
                    }
                    int n8 = i;
                    dArray6[n8] = dArray6[n8] + 0.5 * (d3 * d4);
                }
            }
        }
        double[] dArray7 = new double[n5];
        for (int i = 0; i < dArray7.length; ++i) {
            dArray7[i] = dArray6[i] / (double)(n5 - 1);
        }
        double d5 = 0.0;
        for (int i = 0; i < dArray7.length; ++i) {
            d5 += dArray7[i];
        }
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        doubleArrayResult.add(n4);
        doubleArrayResult.add(n3);
        doubleArrayResult.add(d);
        doubleArrayResult.add(d5);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, names);
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(names.length);
    }
}

