/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.processors.structure;

import ambit2.base.config.Preferences;
import ambit2.base.exceptions.AmbitException;
import ambit2.base.processors.DefaultAmbitProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class AtomConfigurator
extends DefaultAmbitProcessor<IAtomContainer, IAtomContainer> {
    private static final long serialVersionUID = -1245226849382037921L;

    public IAtomContainer process(IAtomContainer iAtomContainer) throws AmbitException {
        Object object;
        if (iAtomContainer == null) {
            throw new AmbitException("Null molecule!");
        }
        if (iAtomContainer.getAtomCount() == 0) {
            throw new AmbitException("No atoms!");
        }
        logger.debug((Object)"Configuring atom types ...");
        CDKAtomTypeMatcher cDKAtomTypeMatcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)iAtomContainer.getBuilder());
        Iterator iterator = iAtomContainer.atoms().iterator();
        ArrayList<String> arrayList = null;
        while (iterator.hasNext()) {
            IAtom iAtom = (IAtom)iterator.next();
            if (iAtom instanceof IPseudoAtom) continue;
            try {
                object = cDKAtomTypeMatcher.findMatchingAtomType(iAtomContainer, iAtom);
                if (object != null) {
                    AtomTypeManipulator.configure((IAtom)iAtom, (IAtomType)object);
                    iAtom.setValency(object.getValency());
                    iAtom.setAtomicNumber(object.getAtomicNumber());
                    iAtom.setExactMass(object.getExactMass());
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                if (arrayList.indexOf(iAtom.getSymbol()) >= 0) continue;
                arrayList.add(String.format("%s", iAtom.getSymbol()));
            }
            catch (Exception exception) {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                if (arrayList.indexOf(iAtom.getSymbol()) >= 0) continue;
                arrayList.add(String.format("%s", iAtom.getSymbol()));
            }
        }
        if (arrayList != null && "true".equals(Preferences.getProperty((String)Preferences.STOP_AT_UNKNOWNATOMTYPES))) {
            Collections.sort(arrayList);
            throw new AmbitException(((Object)arrayList).toString());
        }
        for (IAtom iAtom : iAtomContainer.atoms()) {
            if (iAtom.getAtomicNumber() != null && iAtom.getAtomicNumber() != 0 || (object = PeriodicTable.getAtomicNumber((String)iAtom.getSymbol())) == null) continue;
            iAtom.setAtomicNumber(Integer.valueOf((Integer)object));
        }
        return iAtomContainer;
    }
}

