/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.processors.structure;

import ambit2.base.data.Property;
import ambit2.base.exceptions.AmbitException;
import ambit2.base.interfaces.IStructureRecord;
import ambit2.base.processors.DefaultAmbitProcessor;
import ambit2.core.processors.structure.MoleculeReader;
import org.openscience.cdk.interfaces.IAtomContainer;

public abstract class AbstractPropertyGenerator<P>
extends DefaultAmbitProcessor<IStructureRecord, IStructureRecord> {
    private static final long serialVersionUID = 6923827535809255431L;
    protected MoleculeReader reader = new MoleculeReader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStructureRecord process(IStructureRecord iStructureRecord) throws AmbitException {
        IAtomContainer iAtomContainer = this.getAtomContainer(iStructureRecord);
        long l = System.currentTimeMillis();
        try {
            Object object = this.generateProperty(iAtomContainer);
            iStructureRecord.setProperty(this.getProperty(), object);
        }
        catch (Exception exception) {
            iStructureRecord.setProperty(this.getProperty(), null);
        }
        finally {
            Property property = this.getTimeProperty();
            if (property != null) {
                iStructureRecord.setProperty(this.getTimeProperty(), (Object)(System.currentTimeMillis() - l));
            }
        }
        return iStructureRecord;
    }

    protected abstract Property getProperty();

    protected abstract Property getTimeProperty();

    protected abstract P generateProperty(IAtomContainer var1) throws AmbitException;

    protected IAtomContainer getAtomContainer(IStructureRecord iStructureRecord) throws AmbitException {
        return this.reader.process(iStructureRecord);
    }
}

