/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.groups;

import ambit2.core.data.MoleculeTools;
import ambit2.core.groups.AbstractGroup;
import ambit2.core.groups.IExpandable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;

public class SuperAtom
extends AbstractGroup
implements IExpandable {
    boolean expanded = true;
    protected List<IBond> contractedBonds;
    private static final long serialVersionUID = -3485052440705149342L;

    public SuperAtom(String string, int n) {
        super(string, n);
        this.bonds = new ArrayList();
        this.contractedBonds = new ArrayList<IBond>();
        SuperAtom.setGroupVisible((IChemObject)this, false);
        this.setPoint2d(new Point2d(0.0, 0.0));
    }

    @Override
    public void setSubscript(String string) {
        super.setSubscript(string);
    }

    @Override
    public void finalizeAtomList(IAtomContainer iAtomContainer) {
        this.addBondsConnected2Atoms(iAtomContainer, this.atoms, this.bonds);
    }

    @Override
    public IBond addBond(IBond iBond) {
        IBond iBond2 = MoleculeTools.newBond(this.getBuilder());
        iBond2.setOrder(iBond.getOrder());
        Iterator iterator = iBond.atoms().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            IAtom iAtom = (IAtom)iterator.next();
            if (this.atoms.contains(iAtom)) {
                iBond2.setAtom((IAtom)this, n++);
                this.setPoint2d(new Point2d(iAtom.getPoint2d().x, iAtom.getPoint2d().y));
                continue;
            }
            iBond2.setAtom(iAtom, n++);
        }
        this.contractedBonds.add(iBond2);
        super.addBond(iBond);
        return iBond2;
    }

    @Override
    public Iterable<IBond> getBonds(boolean bl) {
        if (bl) {
            return new Iterable<IBond>(){

                @Override
                public Iterator<IBond> iterator() {
                    return SuperAtom.this.bonds.iterator();
                }
            };
        }
        return new Iterable<IBond>(){

            @Override
            public Iterator<IBond> iterator() {
                return SuperAtom.this.contractedBonds.iterator();
            }
        };
    }

    @Override
    public Iterable<IAtom> getAtoms(boolean bl) {
        if (bl) {
            return new Iterable<IAtom>(){

                @Override
                public Iterator<IAtom> iterator() {
                    return SuperAtom.this.atoms.iterator();
                }
            };
        }
        return new AbstractGroup.SelfIterable<IAtom>(this);
    }

    @Override
    public boolean isExpanded(IBond iBond) {
        return super.isExpanded(iBond);
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(boolean bl) {
        if (this.expanded != bl) {
            for (IAtom iAtom : this.getAtoms(this.expanded)) {
                SuperAtom.setGroupVisible((IChemObject)iAtom, false);
            }
            for (IBond iBond : this.getBonds(this.expanded)) {
                SuperAtom.setGroupVisible((IChemObject)iBond, false);
            }
            this.expanded = bl;
            for (IAtom iAtom : this.getAtoms(this.expanded)) {
                SuperAtom.setGroupVisible((IChemObject)iAtom, true);
            }
            for (IBond iBond : this.getBonds(this.expanded)) {
                SuperAtom.setGroupVisible((IChemObject)iBond, true);
            }
        }
    }
}

