/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import java.io.Serializable;

public class CholeskyDecomposition
implements Serializable {
    private double[][] L;
    private int n;
    private boolean isspd;

    public CholeskyDecomposition(Matrix matrix) {
        double[][] dArray = matrix.getArray();
        this.n = matrix.getRowDimension();
        this.L = new double[this.n][this.n];
        this.isspd = matrix.getColumnDimension() == this.n;
        int n = 0;
        while (n < this.n) {
            double[] dArray2 = this.L[n];
            double d = 0.0;
            int n2 = 0;
            while (n2 < n) {
                double[] dArray3 = this.L[n2];
                double d2 = 0.0;
                int n3 = 0;
                while (n3 < n2) {
                    d2 += dArray3[n3] * dArray2[n3];
                    ++n3;
                }
                dArray2[n2] = d2 = (dArray[n][n2] - d2) / this.L[n2][n2];
                d += d2 * d2;
                this.isspd &= dArray[n2][n] == dArray[n][n2];
                ++n2;
            }
            this.isspd &= (d = dArray[n][n] - d) > 0.0;
            this.L[n][n] = Math.sqrt(Math.max(d, 0.0));
            int n4 = n + 1;
            while (n4 < this.n) {
                this.L[n][n4] = 0.0;
                ++n4;
            }
            ++n;
        }
    }

    public Matrix getL() {
        return new Matrix(this.L, this.n, this.n);
    }

    public boolean isSPD() {
        return this.isspd;
    }

    public Matrix solve(Matrix matrix) {
        int n;
        int n2;
        if (matrix.getRowDimension() != this.n) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isspd) {
            throw new RuntimeException("Matrix is not symmetric positive definite.");
        }
        double[][] dArray = matrix.getArrayCopy();
        int n3 = matrix.getColumnDimension();
        int n4 = 0;
        while (n4 < this.n) {
            n2 = n4 + 1;
            while (n2 < this.n) {
                n = 0;
                while (n < n3) {
                    double[] dArray2 = dArray[n2];
                    int n5 = n;
                    dArray2[n5] = dArray2[n5] - dArray[n4][n] * this.L[n2][n4];
                    ++n;
                }
                ++n2;
            }
            n = 0;
            while (n < n3) {
                double[] dArray3 = dArray[n4];
                int n6 = n++;
                dArray3[n6] = dArray3[n6] / this.L[n4][n4];
            }
            ++n4;
        }
        n2 = this.n - 1;
        while (n2 >= 0) {
            n = 0;
            while (n < n3) {
                double[] dArray4 = dArray[n2];
                int n7 = n++;
                dArray4[n7] = dArray4[n7] / this.L[n2][n2];
            }
            int n8 = 0;
            while (n8 < n2) {
                int n9 = 0;
                while (n9 < n3) {
                    double[] dArray5 = dArray[n8];
                    int n10 = n9;
                    dArray5[n10] = dArray5[n10] - dArray[n2][n9] * this.L[n2][n8];
                    ++n9;
                }
                ++n8;
            }
            --n2;
        }
        return new Matrix(dArray, this.n, n3);
    }
}

