/*
 * Decompiled with CFR 0.152.
 */
package signature;

import junit.framework.Assert;
import org.junit.Test;
import signature.simple.SimpleGraph;
import signature.simple.SimpleVertexSignature;

public class HeightTest {
    public SimpleGraph makeTorus(int width, int height) {
        int y;
        int x;
        int j;
        SimpleGraph graph = new SimpleGraph();
        int i = 0;
        while (i < width - 1) {
            j = 0;
            while (j < height) {
                x = width * j + i;
                y = x + 1;
                graph.makeEdge(x, y);
                if (j < height - 1) {
                    int z = width * (j + 1) + i;
                    graph.makeEdge(x, z);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < height - 1) {
            int x2 = (i + 1) * width - 1;
            int y2 = (i + 2) * width - 1;
            graph.makeEdge(x2, y2);
            ++i;
        }
        int size = width * height;
        int i2 = 0;
        while (i2 < width) {
            graph.makeEdge(i2, size - width + i2);
            ++i2;
        }
        j = 0;
        while (j < height) {
            x = width * j;
            y = x + width - 1;
            graph.makeEdge(x, y);
            ++j;
        }
        return graph;
    }

    public void regularGraphTest(SimpleGraph graph, int diameter) {
        int h = 1;
        while (h <= diameter) {
            SimpleVertexSignature sig0 = new SimpleVertexSignature(0, h, graph);
            String zeroCanonical = sig0.toCanonicalString();
            System.out.println(String.valueOf(h) + "\t" + zeroCanonical);
            int i = 1;
            while (i < graph.getVertexCount()) {
                SimpleVertexSignature sig = new SimpleVertexSignature(i, h, graph);
                String canString = sig.toCanonicalString();
                if (!zeroCanonical.equals(canString)) {
                    System.out.println("NEQ " + h + "\t" + i + "\t" + zeroCanonical + " " + canString);
                }
                Assert.assertEquals((String)zeroCanonical, (String)canString);
                ++i;
            }
            ++h;
        }
    }

    @Test
    public void torusTest() {
        int width = 6;
        int height = 6;
        SimpleGraph torus = this.makeTorus(width, height);
        System.out.println(torus);
        int diameter = Math.min(width, height);
        this.regularGraphTest(torus, diameter);
    }

    public SimpleGraph makeCompleteGraph(int n) {
        SimpleGraph g = new SimpleGraph();
        int i = 0;
        while (i < n) {
            int j = i + 1;
            while (j < n) {
                g.makeEdge(i, j);
                ++j;
            }
            ++i;
        }
        return g;
    }

    @Test
    public void completeGraphTest() {
        int n = 7;
        SimpleGraph kN = this.makeCompleteGraph(n);
        int expectedEdgeCount = n * (n - 1) / 2;
        Assert.assertEquals((int)expectedEdgeCount, (int)kN.edges.size());
        this.regularGraphTest(kN, n - 1);
    }

    public static void main(String[] args) {
        new HeightTest().torusTest();
    }
}

