/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.features;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMolecule;

public class MoleculeFeaturesTool {
    public static boolean hasPartialCharges(IMolecule molecule) {
        for (IAtom atom : molecule.atoms()) {
            if (atom.getCharge() == 0.0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFormalCharges(IMolecule molecule) {
        for (IAtom atom : molecule.atoms()) {
            if (atom.getFormalCharge() == 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasElementSymbols(IMolecule molecule) {
        for (IAtom atom : molecule.atoms()) {
            if (atom.getSymbol() == null || atom.getSymbol().length() <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasGraphRepresentation(IMolecule molecule) {
        for (IBond bond : molecule.bonds()) {
            if (bond.getAtomCount() == 2) continue;
            return false;
        }
        return true;
    }
}

