/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.builtins;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.vocabulary.RDFS;

public class IsDType
extends BaseBuiltin {
    public String getName() {
        return "isDType";
    }

    public int getArgLength() {
        return 2;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        this.checkArgs(length, context);
        Node val = this.getArg(0, args, context);
        Node dt = this.getArg(1, args, context);
        return IsDType.isTypeOK(val, dt);
    }

    public static boolean isTypeOK(Node val, Node dt) {
        if (!dt.isURI()) {
            return false;
        }
        if (val.isBlank()) {
            return true;
        }
        if (val.isLiteral()) {
            LiteralLabel ll = val.getLiteral();
            if (ll.getDatatype() != null && !ll.isWellFormed()) {
                return false;
            }
            if (dt.equals(RDFS.Nodes.Literal)) {
                return true;
            }
            RDFDatatype dtype = TypeMapper.getInstance().getSafeTypeByName(dt.getURI());
            return dtype.isValidLiteral(val.getLiteral());
        }
        return false;
    }
}

