/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.core.io.DelimitedFileFormat;
import ambit2.core.io.IteratingDelimitedFileReader;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.openscience.cdk.exception.CDKException;

public class ToxcastAssayReader
extends IteratingDelimitedFileReader {
    protected static final String prefix = "DSSTOX_";
    protected static final String DSSTox_RID = "DSSTox_RID";
    protected static final String ToxCast_signature = "# EPA ToxCast Phase I Data";
    protected boolean isToxCastAssayFile = false;
    protected int DSSTOX_RID_index = -1;

    public ToxcastAssayReader(InputStream inputStream) throws UnsupportedEncodingException, CDKException {
        super(inputStream, new DelimitedFileFormat("\t ", '\"'));
    }

    public ToxcastAssayReader(Reader reader) throws CDKException {
        super(reader, new DelimitedFileFormat("\t ", '\"'));
    }

    @Override
    protected void processComment(String string) {
        if (string.startsWith(ToxCast_signature)) {
            this.isToxCastAssayFile = true;
        }
    }

    @Override
    protected void addHeaderColumn(String string) {
        try {
            Assay_column assay_column = Assay_column.valueOf(string);
            super.addHeaderColumn(assay_column.getDSSTOXName());
        }
        catch (Exception exception) {
            super.addHeaderColumn(string);
        }
    }

    @Override
    protected void processHeader(BufferedReader bufferedReader) {
        super.processHeader(bufferedReader);
        if (this.isToxCastAssayFile) {
            for (int i = 0; i < this.getNumberOfColumns(); ++i) {
                if (!((String)this.getHeaderColumn(i)).toString().equals(DSSTox_RID)) continue;
                this.DSSTOX_RID_index = i;
                break;
            }
        }
    }

    @Override
    public void extractRowKeyAndData(String string) {
        super.extractRowKeyAndData(string);
        if (this.isToxCastAssayFile && this.DSSTOX_RID_index >= 0) {
            this.values[this.DSSTOX_RID_index] = Assay_column.SOURCE_NAME_SID.getValue(this.values[this.DSSTOX_RID_index].toString());
        }
    }

    static enum Assay_column {
        SOURCE_NAME_SID{

            @Override
            public String getDSSTOXName() {
                return ToxcastAssayReader.DSSTox_RID;
            }

            @Override
            public String getValue(String string) {
                if (string.startsWith(ToxcastAssayReader.prefix)) {
                    return string.substring(7);
                }
                return string;
            }
        };


        public String getDSSTOXName() {
            return this.toString();
        }

        public String getValue(String string) {
            return string;
        }
    }
}

