/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.chemistry;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.chemistry.CompoundAbstractProcessing;
import com.rapidminer.operator.chemistry.Compounds;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

public class CompoundDetectDimensionality
extends CompoundAbstractProcessing {
    public CompoundDetectDimensionality(OperatorDescription operatorDescription) {
        super(operatorDescription);
    }

    public void doWork() throws OperatorException {
        Compounds compounds = (Compounds)this.molInput.getData();
        Compounds compounds2 = new Compounds();
        ArrayList<String> arrayList = new ArrayList<String>(compounds.size());
        ArrayList<String> arrayList2 = new ArrayList<String>(compounds.size());
        ArrayList<String> arrayList3 = new ArrayList<String>(compounds.size());
        ArrayList<String> arrayList4 = new ArrayList<String>(compounds.size());
        DecimalFormat decimalFormat = new DecimalFormat("#0.0000");
        int n = compounds.size();
        for (int i = 0; i < n; ++i) {
            IAtomContainer iAtomContainer = compounds.getMolecule(i);
            try {
                compounds2.addMolecule(iAtomContainer.clone());
            }
            catch (Exception exception) {
                Logger.getLogger("global").log(Level.FINE, null, exception);
            }
            double d = 0.0;
            double d2 = Double.MAX_VALUE;
            double d3 = -1.7976931348623157E308;
            double d4 = 0.0;
            double d5 = Double.MAX_VALUE;
            double d6 = -1.7976931348623157E308;
            double d7 = 0.0;
            double d8 = Double.MAX_VALUE;
            double d9 = -1.7976931348623157E308;
            int n2 = iAtomContainer.getAtomCount();
            for (int j = 0; j < n2; ++j) {
                IAtom iAtom = iAtomContainer.getAtom(j);
                Point3d point3d = iAtom.getPoint3d();
                if (point3d != null) {
                    d += point3d.x;
                    d2 = Math.min(d2, point3d.x);
                    d3 = Math.max(d3, point3d.x);
                    d4 += point3d.y;
                    d5 = Math.min(d5, point3d.y);
                    d6 = Math.max(d6, point3d.y);
                    d7 += point3d.z;
                    d8 = Math.min(d8, point3d.z);
                    d9 = Math.max(d9, point3d.z);
                    continue;
                }
                Point2d point2d = iAtom.getPoint2d();
                if (point2d != null) {
                    d += point2d.x;
                    d2 = Math.min(d2, point2d.x);
                    d3 = Math.max(d3, point2d.x);
                    d4 += point2d.y;
                    d5 = Math.min(d5, point2d.y);
                    d6 = Math.max(d6, point2d.y);
                    d7 += 0.0;
                    d8 = Math.min(d8, 0.0);
                    d9 = Math.max(d9, 0.0);
                    continue;
                }
                d += 0.0;
                d2 = Math.min(d2, 0.0);
                d3 = Math.max(d3, 0.0);
                d4 += 0.0;
                d5 = Math.min(d5, 0.0);
                d6 = Math.max(d6, 0.0);
                d7 += 0.0;
                d8 = Math.min(d8, 0.0);
                d9 = Math.max(d9, 0.0);
            }
            arrayList2.add(decimalFormat.format(d / (double)iAtomContainer.getAtomCount()) + " [" + decimalFormat.format(d2) + " ; " + decimalFormat.format(d3) + "]");
            arrayList3.add(decimalFormat.format(d4 / (double)iAtomContainer.getAtomCount()) + " [" + decimalFormat.format(d5) + " ; " + decimalFormat.format(d6) + "]");
            arrayList4.add(decimalFormat.format(d7 / (double)iAtomContainer.getAtomCount()) + " [" + decimalFormat.format(d8) + " ; " + decimalFormat.format(d9) + "]");
            if (d2 == d3 && d5 == d6 && d8 == d9) {
                arrayList.add("0D");
                continue;
            }
            if (d2 == d3 && d5 == d6 || d2 == d3 && d8 == d9 || d5 == d6 && d8 == d9) {
                arrayList.add("1D");
                continue;
            }
            if (d2 == d3 || d5 == d6 || d8 == d9) {
                arrayList.add("2D");
                continue;
            }
            arrayList.add("3D");
        }
        compounds.addColumn("xcoord", arrayList2.toArray(new String[0]));
        compounds.addColumn("ycoord", arrayList3.toArray(new String[0]));
        compounds.addColumn("zcoord", arrayList4.toArray(new String[0]));
        compounds.addColumn("dimensionality", arrayList.toArray(new String[0]));
        this.molOriginal.deliver((IOObject)compounds2);
        this.molOutput.deliver((IOObject)compounds);
    }
}

