/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.processors.structure.key;

import ambit2.base.data.Property;
import ambit2.base.exceptions.AmbitException;
import ambit2.base.interfaces.IStructureRecord;
import ambit2.base.processors.DefaultAmbitProcessor;
import ambit2.core.processors.structure.key.IStructureKey;
import java.util.Iterator;

public abstract class PropertyKey<Result>
extends DefaultAmbitProcessor<IStructureRecord, Result>
implements IStructureKey<IStructureRecord, Result> {
    private static final long serialVersionUID = 6393097111823664858L;
    protected Property key = null;

    public PropertyKey() {
        this(null);
    }

    public PropertyKey(Property property) {
        this.setKey(property);
    }

    @Override
    public Object getKey() {
        if (this.key == null) {
            return null;
        }
        return this.key;
    }

    public void setKey(Property property) {
        this.key = property;
    }

    public boolean isKeyValid(Property property) {
        return true;
    }

    public Result process(IStructureRecord iStructureRecord) throws AmbitException {
        if (iStructureRecord == null) {
            throw new AmbitException("Empty molecule!");
        }
        if (this.key == null || iStructureRecord.getProperty(this.key) == null) {
            for (Property property : iStructureRecord.getProperties()) {
                if (!this.isKeyValid(property) || !this.isValid(property, iStructureRecord.getProperty(property).toString())) continue;
                this.key = property;
                return this.getProperty(iStructureRecord);
            }
        }
        if (this.key == null) {
            throw new AmbitException(this.toString() + " not defined");
        }
        Iterator<Object> iterator = this.getProperty(iStructureRecord);
        if (iterator != null && this.isValid(this.key, iterator.toString())) {
            return (Result)iterator;
        }
        return null;
    }

    protected Result getProperty(IStructureRecord iStructureRecord) throws AmbitException {
        return (Result)iStructureRecord.getProperty(this.key);
    }

    public String toString() {
        return "Custom key to match structures";
    }

    protected boolean isValid(Object object, Object object2) {
        return object != null;
    }

    @Override
    public Object getQueryKey() {
        return null;
    }

    @Override
    public abstract Class getType();
}

