/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.processors.structure;

import ambit2.base.config.Preferences;
import ambit2.base.exceptions.AmbitException;
import ambit2.core.processors.structure.AtomConfigurator;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class HydrogenAdderProcessor
extends AtomConfigurator {
    protected CDKHydrogenAdder adder = CDKHydrogenAdder.getInstance((IChemObjectBuilder)SilentChemObjectBuilder.getInstance());
    protected boolean addEexplicitHydrogens = true;
    private static final long serialVersionUID = -6788800174158558265L;

    public boolean isAddEexplicitHydrogens() {
        return this.addEexplicitHydrogens;
    }

    public void setAddEexplicitHydrogens(boolean bl) {
        this.addEexplicitHydrogens = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IAtomContainer process(IAtomContainer iAtomContainer) throws AmbitException {
        super.process(iAtomContainer);
        try {
            if (iAtomContainer instanceof IMolecule || iAtomContainer instanceof IAtomContainer) {
                try {
                    this.adder.addImplicitHydrogens(iAtomContainer);
                    logger.debug((Object)("Adding implicit hydrogens; atom count " + iAtomContainer.getAtomCount()));
                    if (!this.isAddEexplicitHydrogens()) return iAtomContainer;
                    AtomContainerManipulator.convertImplicitToExplicitHydrogens((IAtomContainer)iAtomContainer);
                    logger.debug((Object)("Convert explicit hydrogens; atom count " + iAtomContainer.getAtomCount()));
                    return iAtomContainer;
                }
                catch (Exception exception) {
                    logger.error((Object)exception);
                    if (!"true".equals(Preferences.getProperty((String)Preferences.STOP_AT_UNKNOWNATOMTYPES))) return iAtomContainer;
                    throw new AmbitException((Throwable)exception);
                }
            } else {
                IMoleculeSet iMoleculeSet = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)iAtomContainer);
                for (int i = 0; i < iMoleculeSet.getMoleculeCount(); ++i) {
                    IMolecule iMolecule = iMoleculeSet.getMolecule(i);
                    this.adder.addImplicitHydrogens((IAtomContainer)iMolecule);
                    logger.debug((Object)("Adding implicit hydrogens; atom count " + iMolecule.getAtomCount()));
                    if (!this.isAddEexplicitHydrogens()) continue;
                    AtomContainerManipulator.convertImplicitToExplicitHydrogens((IAtomContainer)iMolecule);
                    logger.debug((Object)("Convert explicit hydrogens; atom count " + iMolecule.getAtomCount()));
                }
            }
            return iAtomContainer;
        }
        catch (CDKException cDKException) {
            throw new AmbitException((Throwable)cDKException);
        }
    }
}

