/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.NoSuchElementException;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SMILESFormat;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.io.iterator.IteratingSMILESReaderTest")
public class PaDELIteratingSMILESReader
extends DefaultIteratingChemObjectReader {
    private BufferedReader input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(PaDELIteratingSMILESReader.class);
    private String currentLine;
    private SmilesParser sp = null;
    private boolean nextAvailableIsKnown;
    private boolean hasNext;
    private IMolecule nextMolecule;

    @TestMethod(value="testSMILESFileWithNames")
    public PaDELIteratingSMILESReader(Reader reader, IChemObjectBuilder iChemObjectBuilder) {
        this.sp = new SmilesParser(iChemObjectBuilder);
        this.sp.setPreservingAromaticity(true);
        this.setReader(reader);
    }

    @TestMethod(value="testSMILESFileWithNames")
    public PaDELIteratingSMILESReader(InputStream inputStream) {
        this(new InputStreamReader(inputStream), DefaultChemObjectBuilder.getInstance());
    }

    public PaDELIteratingSMILESReader(InputStream inputStream, IChemObjectBuilder iChemObjectBuilder) {
        this(new InputStreamReader(inputStream), iChemObjectBuilder);
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return SMILESFormat.getInstance();
    }

    @Override
    @TestMethod(value="testSMILESFileWithNames,testSMILESFileWithSpacesAndTabs,testSMILESTitles,testSMILESFile")
    public boolean hasNext() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext = false;
            try {
                if (this.input.ready()) {
                    this.currentLine = this.input.readLine().trim();
                    logger.debug("Line: ", this.currentLine);
                    int n = this.currentLine.indexOf(" ");
                    if (n == -1) {
                        n = this.currentLine.indexOf("\t");
                    }
                    String string = this.currentLine;
                    String string2 = null;
                    if (n != -1) {
                        logger.debug("Space found at index: ", n);
                        string = this.currentLine.substring(0, n);
                        string2 = this.currentLine.substring(n + 1);
                        string2 = string2.trim();
                        logger.debug("Line contains SMILES and name: ", string, " + ", string2);
                    }
                    this.nextMolecule = this.sp.parseSmiles(string);
                    if (string2 != null) {
                        this.nextMolecule.setProperty("cdk:Title", string2);
                    }
                    this.hasNext = this.nextMolecule.getAtomCount() > 0;
                } else {
                    this.hasNext = false;
                }
            }
            catch (Exception exception) {
                logger.error("Error while reading next molecule: ", exception.getMessage());
                logger.debug(exception);
                this.hasNext = false;
            }
            if (!this.hasNext) {
                this.nextMolecule = null;
            }
            this.nextAvailableIsKnown = true;
        }
        return this.hasNext;
    }

    @Override
    @TestMethod(value="testSMILESFileWithNames,testSMILESFileWithSpacesAndTabs,testSMILESTitles,testSMILESFile")
    public IChemObject next() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext();
        }
        this.nextAvailableIsKnown = false;
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.nextMolecule;
    }

    @Override
    @TestMethod(value="testSMILESFileWithNames,testSMILESFileWithSpacesAndTabs,testClose")
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    @TestMethod(value="testRemove")
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader reader) {
        this.input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.nextMolecule = null;
        this.nextAvailableIsKnown = false;
        this.hasNext = false;
    }

    @Override
    @TestMethod(value="testSetReader1,testSetReader_InputStream")
    public void setReader(InputStream inputStream) {
        this.setReader(new InputStreamReader(inputStream));
    }
}

