/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.util.BitSet;
import org.jmol.modelset.Atom;
import org.jmol.quantum.MepCalculation;
import org.jmol.util.Logger;

public class MlpCalculation
extends MepCalculation {
    public MlpCalculation() {
        this.distanceMode = 3;
    }

    public void assignPotentials(Atom[] atomArray, float[] fArray, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, String string) {
        this.getAtomicPotentials(string, "atomicLipophilicity.txt");
        for (int i = 0; i < atomArray.length; ++i) {
            float f = Math.abs(atomArray[i].getFormalCharge());
            if (f == 0.0f) {
                if (bitSet3 != null && bitSet3.get(i)) {
                    f = Float.NaN;
                } else {
                    f = this.getTabulatedPotential(atomArray[i]);
                    if (Float.isNaN(f)) {
                        switch (atomArray[i].getElementNumber()) {
                            case 6: {
                                f = bitSet.get(i) ? 0.31f : (bitSet2.get(i) ? -0.54f : 0.45f);
                                break;
                            }
                            case 7: {
                                f = bitSet.get(i) ? -0.6f : (bitSet2.get(i) ? -0.44f : -1.0f);
                                break;
                            }
                            case 8: {
                                f = bitSet2.get(i) ? -0.9f : -0.17f;
                                break;
                            }
                            default: {
                                f = Float.NaN;
                            }
                        }
                    }
                }
            }
            if (Logger.debugging) {
                Logger.info(atomArray[i].getInfo() + " " + f);
            }
            fArray[i] = f;
        }
    }
}

