/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.processors.structure;

import ambit2.base.exceptions.AmbitException;
import ambit2.base.processors.DefaultAmbitProcessor;
import net.sf.jniinchi.INCHI_RET;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.inchi.InChIGenerator;
import org.openscience.cdk.inchi.InChIGeneratorFactory;
import org.openscience.cdk.interfaces.IAtomContainer;

public class InchiProcessor
extends DefaultAmbitProcessor<IAtomContainer, InChIGenerator> {
    private static final long serialVersionUID = -9052892261511104974L;
    protected InChIGeneratorFactory factory = InChIGeneratorFactory.getInstance();

    public InChIGenerator process(IAtomContainer iAtomContainer) throws AmbitException {
        try {
            InChIGenerator inChIGenerator = this.factory.getInChIGenerator(iAtomContainer);
            INCHI_RET iNCHI_RET = inChIGenerator.getReturnStatus();
            if (iNCHI_RET == INCHI_RET.WARNING) {
                logger.warn((Object)("InChI warning: " + inChIGenerator.getMessage()));
            } else if (iNCHI_RET != INCHI_RET.OKAY) {
                throw new AmbitException("InChI failed: " + iNCHI_RET.toString() + " [" + inChIGenerator.getMessage() + "]");
            }
            return inChIGenerator;
        }
        catch (CDKException cDKException) {
            throw new AmbitException((Throwable)cDKException);
        }
    }
}

