/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.tools.manipulator.ChemSequenceManipulatorTest")
public class ChemSequenceManipulator {
    @TestMethod(value="testGetAtomCount_IChemSequence")
    public static int getAtomCount(IChemSequence sequence) {
        int count = 0;
        for (int i = 0; i < sequence.getChemModelCount(); ++i) {
            count += ChemModelManipulator.getAtomCount(sequence.getChemModel(i));
        }
        return count;
    }

    @TestMethod(value="testGetBondCount_IChemSequence")
    public static int getBondCount(IChemSequence sequence) {
        int count = 0;
        for (int i = 0; i < sequence.getChemModelCount(); ++i) {
            count += ChemModelManipulator.getBondCount(sequence.getChemModel(i));
        }
        return count;
    }

    @TestMethod(value="testGetAllAtomContainers_IChemSequence")
    public static List<IAtomContainer> getAllAtomContainers(IChemSequence sequence) {
        ArrayList<IAtomContainer> acList = new ArrayList<IAtomContainer>();
        for (IChemModel model : sequence.chemModels()) {
            acList.addAll(ChemModelManipulator.getAllAtomContainers(model));
        }
        return acList;
    }

    @TestMethod(value="testGetAllChemObjects_IChemSequence")
    public static List<IChemObject> getAllChemObjects(IChemSequence sequence) {
        ArrayList<IChemObject> list = new ArrayList<IChemObject>();
        for (int i = 0; i < sequence.getChemModelCount(); ++i) {
            list.add(sequence.getChemModel(i));
            List<IChemObject> current = ChemModelManipulator.getAllChemObjects(sequence.getChemModel(i));
            for (IChemObject chemObject : current) {
                if (list.contains(chemObject)) continue;
                list.add(chemObject);
            }
        }
        return list;
    }

    @TestMethod(value="testGetAllIDs_IChemSequence")
    public static List<String> getAllIDs(IChemSequence sequence) {
        ArrayList<String> list = new ArrayList<String>();
        if (sequence.getID() != null) {
            list.add(sequence.getID());
        }
        for (int i = 0; i < sequence.getChemModelCount(); ++i) {
            list.addAll(ChemModelManipulator.getAllIDs(sequence.getChemModel(i)));
        }
        return list;
    }
}

