/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.vflib.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smsd.algorithm.vflib.builder.TargetProperties;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.IMapper;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.INode;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.IQuery;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.IState;
import org.openscience.cdk.smsd.algorithm.vflib.map.Match;
import org.openscience.cdk.smsd.algorithm.vflib.map.VFState;
import org.openscience.cdk.smsd.algorithm.vflib.query.QueryCompiler;
import org.openscience.cdk.smsd.global.TimeOut;
import org.openscience.cdk.smsd.tools.TimeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.smsd.algorithm.vflib.VFLibTest")
public class VFMapper
implements IMapper {
    private IQuery query;
    private List<Map<INode, IAtom>> maps;
    private int currentMCSSize = -1;
    private static TimeManager timeManager = null;

    protected static synchronized double getTimeout() {
        return TimeOut.getInstance().getTimeOut();
    }

    protected static synchronized TimeManager getTimeManager() {
        return timeManager;
    }

    protected static synchronized void setTimeManager(TimeManager aTimeManager) {
        TimeOut.getInstance().setTimeOutFlag(false);
        timeManager = aTimeManager;
    }

    public VFMapper(IQuery query2) {
        VFMapper.setTimeManager(new TimeManager());
        this.query = query2;
        this.maps = new ArrayList<Map<INode, IAtom>>();
    }

    public VFMapper(IAtomContainer queryMolecule, boolean bondMatcher) {
        VFMapper.setTimeManager(new TimeManager());
        this.query = new QueryCompiler(queryMolecule, bondMatcher).compile();
        this.maps = new ArrayList<Map<INode, IAtom>>();
    }

    @Override
    public boolean hasMap(IAtomContainer targetMolecule) {
        VFState state = new VFState(this.query, new TargetProperties(targetMolecule));
        this.maps.clear();
        return this.mapFirst(state);
    }

    @Override
    public List<Map<INode, IAtom>> getMaps(IAtomContainer target) {
        VFState state = new VFState(this.query, new TargetProperties(target));
        this.maps.clear();
        this.mapAll(state);
        return new ArrayList<Map<INode, IAtom>>(this.maps);
    }

    @Override
    public Map<INode, IAtom> getFirstMap(IAtomContainer target) {
        VFState state = new VFState(this.query, new TargetProperties(target));
        this.maps.clear();
        this.mapFirst(state);
        return this.maps.isEmpty() ? new HashMap<INode, IAtom>() : this.maps.get(0);
    }

    @Override
    public int countMaps(IAtomContainer target) {
        VFState state = new VFState(this.query, new TargetProperties(target));
        this.maps.clear();
        this.mapAll(state);
        return this.maps.size();
    }

    @Override
    public boolean hasMap(TargetProperties targetMolecule) {
        VFState state = new VFState(this.query, targetMolecule);
        this.maps.clear();
        return this.mapFirst(state);
    }

    @Override
    public List<Map<INode, IAtom>> getMaps(TargetProperties targetMolecule) {
        VFState state = new VFState(this.query, targetMolecule);
        this.maps.clear();
        this.mapAll(state);
        return new ArrayList<Map<INode, IAtom>>(this.maps);
    }

    @Override
    public Map<INode, IAtom> getFirstMap(TargetProperties targetMolecule) {
        VFState state = new VFState(this.query, targetMolecule);
        this.maps.clear();
        this.mapFirst(state);
        return this.maps.isEmpty() ? new HashMap<INode, IAtom>() : this.maps.get(0);
    }

    @Override
    public int countMaps(TargetProperties targetMolecule) {
        VFState state = new VFState(this.query, targetMolecule);
        this.maps.clear();
        this.mapAll(state);
        return this.maps.size();
    }

    private void addMapping(IState state) {
        Map<INode, IAtom> map = state.getMap();
        if (!this.hasMap(map) && map.size() > this.currentMCSSize) {
            this.maps.add(map);
            this.currentMCSSize = map.size();
        } else if (!this.hasMap(map) && map.size() == this.currentMCSSize) {
            this.maps.add(map);
        }
    }

    private void mapAll(IState state) {
        if (state.isDead()) {
            return;
        }
        if (this.hasMap(state.getMap())) {
            state.backTrack();
        }
        if (state.isGoal()) {
            Map<INode, IAtom> map = state.getMap();
            if (!this.hasMap(map)) {
                this.maps.add(state.getMap());
            } else {
                state.backTrack();
            }
        }
        while (state.hasNextCandidate()) {
            Match candidate = state.nextCandidate();
            if (!state.isMatchFeasible(candidate)) continue;
            IState nextState = state.nextState(candidate);
            this.mapAll(nextState);
            nextState.backTrack();
        }
    }

    private boolean mapFirst(IState state) {
        if (state.isDead()) {
            return false;
        }
        if (state.isGoal()) {
            this.maps.add(state.getMap());
            return true;
        }
        boolean found = false;
        while (!found && state.hasNextCandidate()) {
            Match candidate = state.nextCandidate();
            if (!state.isMatchFeasible(candidate)) continue;
            IState nextState = state.nextState(candidate);
            found = this.mapFirst(nextState);
            nextState.backTrack();
        }
        return found;
    }

    private boolean hasMap(Map<INode, IAtom> map) {
        for (Map<INode, IAtom> storedMap : this.maps) {
            if (!((Object)storedMap).equals(map)) continue;
            return true;
        }
        return false;
    }

    public static synchronized boolean isTimeOut() {
        if (VFMapper.getTimeout() > -1.0 && VFMapper.getTimeManager().getElapsedTimeInMinutes() > VFMapper.getTimeout()) {
            TimeOut.getInstance().setTimeOutFlag(true);
            return true;
        }
        return false;
    }
}

