/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.exception.NoSuchAtomTypeException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.stereo.TetrahedralChirality;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;
import org.openscience.cdk.tools.manipulator.BondManipulator;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

@TestClass(value="org.openscience.cdk.smiles.SmilesParserTest")
public class SmilesParser {
    private static final String HAS_HARDCODED_HYDROGEN_COUNT = "SmilesParser.HasHardcodedHydrogenCount";
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(SmilesParser.class);
    private CDKHydrogenAdder hAdder;
    private int status = 0;
    protected IChemObjectBuilder builder;
    private boolean preservingAromaticity = false;
    int position = -1;
    int nodeCounter = -1;
    String smiles = null;
    IBond.Order bondStatus = null;
    IBond.Order bondStatusForRingClosure = IBond.Order.SINGLE;
    boolean bondIsAromatic = false;
    IAtom[] rings = null;
    IAtom[] ringOtherAtoms = null;
    IBond.Order[] ringbonds = null;
    int thisRing = -1;
    IMolecule molecule = null;
    String currentSymbol = null;
    Map<IAtom, TemporaryChiralityStorage> chiralityInfo = null;

    public SmilesParser(IChemObjectBuilder builder) {
        this.builder = builder;
        try {
            this.hAdder = CDKHydrogenAdder.getInstance(builder);
        }
        catch (Exception exception) {
            logger.error("Could not instantiate hydrogenAdder: ", exception.getMessage());
            logger.debug(exception);
        }
    }

    @TestMethod(value="testReaction,testReactionWithAgents")
    public IReaction parseReactionSmiles(String smiles) throws InvalidSmilesException {
        int i;
        StringTokenizer tokenizer = new StringTokenizer(smiles, ">");
        String reactantSmiles = tokenizer.nextToken();
        String agentSmiles = "";
        String productSmiles = tokenizer.nextToken();
        if (tokenizer.hasMoreTokens()) {
            agentSmiles = productSmiles;
            productSmiles = tokenizer.nextToken();
        }
        IReaction reaction = this.builder.newInstance(IReaction.class, new Object[0]);
        IMolecule reactantContainer = this.parseSmiles(reactantSmiles);
        IMoleculeSet reactantSet = ConnectivityChecker.partitionIntoMolecules(reactantContainer);
        for (int i2 = 0; i2 < reactantSet.getAtomContainerCount(); ++i2) {
            reaction.addReactant(reactantSet.getMolecule(i2));
        }
        if (agentSmiles.length() > 0) {
            IMolecule agentContainer = this.parseSmiles(agentSmiles);
            IMoleculeSet agentSet = ConnectivityChecker.partitionIntoMolecules(agentContainer);
            for (i = 0; i < agentSet.getAtomContainerCount(); ++i) {
                reaction.addAgent(agentSet.getMolecule(i));
            }
        }
        IMolecule productContainer = this.parseSmiles(productSmiles);
        IMoleculeSet productSet = ConnectivityChecker.partitionIntoMolecules(productContainer);
        for (i = 0; i < productSet.getAtomContainerCount(); ++i) {
            reaction.addProduct(productSet.getMolecule(i));
        }
        return reaction;
    }

    @TestMethod(value="testAromaticSmiles,testSFBug1296113")
    public IMolecule parseSmiles(String smiles) throws InvalidSmilesException {
        IMolecule molecule = this.parseString(smiles);
        for (IAtom atom : this.chiralityInfo.keySet()) {
            TemporaryChiralityStorage chirality = this.chiralityInfo.get(atom);
            logger.debug("Chiral atom found: ", atom);
            IAtom[] atoms = chirality.atoms;
            TetrahedralChirality l4Chiral = new TetrahedralChirality(atom, new IAtom[]{atoms[0], atoms[1], atoms[2], atoms[3]}, chirality.chiralityValue == Chirality.CLOCKWISE ? ITetrahedralChirality.Stereo.CLOCKWISE : ITetrahedralChirality.Stereo.ANTI_CLOCKWISE);
            molecule.addStereoElement(l4Chiral);
        }
        CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance(molecule.getBuilder());
        int i = 0;
        for (IAtom atom : molecule.atoms()) {
            ++i;
            try {
                IAtomType type = matcher.findMatchingAtomType(molecule, atom);
                boolean isAromatic = atom.getFlag(5);
                AtomTypeManipulator.configure(atom, type);
                atom.setFlag(5, isAromatic);
            }
            catch (NoSuchAtomTypeException exception) {
                logger.warn("Cannot percieve atom type for the ", i, "th atom: ", atom.getSymbol());
                atom.setAtomTypeName("X");
            }
            catch (Exception exception) {
                logger.error("Caught unexpected Exception during atom typing.");
                logger.debug(exception);
                atom.setAtomTypeName("X");
            }
        }
        this.addImplicitHydrogens(molecule);
        if (!this.preservingAromaticity) {
            this.perceiveAromaticity(molecule);
        } else {
            for (IBond bond : molecule.bonds()) {
                if (bond.getFlag(5) || !bond.getAtom(0).getFlag(5) || !bond.getAtom(1).getFlag(5)) continue;
                bond.setFlag(5, true);
            }
        }
        return molecule;
    }

    private IMolecule parseString(String smiles) throws InvalidSmilesException {
        logger.debug("parseSmiles()...");
        IBond bond = null;
        this.nodeCounter = 0;
        this.bondStatus = null;
        this.bondIsAromatic = false;
        boolean bondExists = true;
        this.thisRing = -1;
        this.currentSymbol = null;
        this.molecule = this.builder.newInstance(IMolecule.class, new Object[0]);
        this.position = 0;
        this.chiralityInfo = new HashMap<IAtom, TemporaryChiralityStorage>();
        int MAX_RING_COUNT = 1024;
        this.rings = new IAtom[1024];
        this.ringOtherAtoms = new IAtom[1024];
        this.ringbonds = new IBond.Order[1024];
        for (int f = 0; f < 1024; ++f) {
            this.rings[f] = null;
            this.ringOtherAtoms[f] = null;
            this.ringbonds[f] = null;
        }
        char mychar = 'X';
        char[] chars = new char[1];
        Object lastNode = null;
        Stack<Object> atomStack = new Stack<Object>();
        Stack<IBond.Order> bondStack = new Stack<IBond.Order>();
        IAtom atom = null;
        do {
            block44: {
                try {
                    IAtom a;
                    Enumeration ses;
                    mychar = smiles.charAt(this.position);
                    logger.debug("");
                    logger.debug("Processing: " + mychar);
                    if (lastNode != null) {
                        logger.debug("Lastnode: ", lastNode.hashCode());
                    }
                    if (mychar >= 'A' && mychar <= 'Z' || mychar >= 'a' && mychar <= 'z' || mychar == '*') {
                        this.status = 1;
                        logger.debug("Found a must-be 'organic subset' element");
                        atom = null;
                        if (mychar == '*') {
                            this.currentSymbol = "*";
                            atom = this.builder.newInstance(IPseudoAtom.class, "*");
                        } else {
                            this.currentSymbol = this.getSymbolForOrganicSubsetElement(smiles, this.position);
                            if (this.currentSymbol != null) {
                                if (this.currentSymbol.length() == 1) {
                                    if (!this.currentSymbol.toUpperCase().equals(this.currentSymbol)) {
                                        this.currentSymbol = this.currentSymbol.toUpperCase();
                                        atom = this.builder.newInstance(IAtom.class, this.currentSymbol);
                                        atom.setHybridization(IAtomType.Hybridization.SP2);
                                        if (this.preservingAromaticity) {
                                            atom.setFlag(5, true);
                                        }
                                    } else {
                                        atom = this.builder.newInstance(IAtom.class, this.currentSymbol);
                                    }
                                } else {
                                    atom = this.builder.newInstance(IAtom.class, this.currentSymbol);
                                }
                                logger.debug("Made atom: ", atom);
                            } else {
                                throw new InvalidSmilesException("Found element which is not a 'organic subset' element. You must use [" + Character.toUpperCase(mychar) + "].");
                            }
                        }
                        this.addAtomToActiveChiralities((IAtom)lastNode, atom);
                        this.molecule.addAtom(atom);
                        logger.debug("Adding atom ", atom.hashCode());
                        if (lastNode != null && bondExists) {
                            logger.debug("Creating bond between ", atom.getSymbol(), " and ", lastNode.getSymbol());
                            bond = this.builder.newInstance(IBond.class, new Object[]{atom, lastNode, this.bondStatus});
                            if (this.bondIsAromatic) {
                                bond.setFlag(5, true);
                                if (this.preservingAromaticity) {
                                    bond.getAtom(0).setFlag(5, true);
                                    bond.getAtom(1).setFlag(5, true);
                                }
                            }
                            this.molecule.addBond(bond);
                        }
                        this.bondStatus = CDKConstants.BONDORDER_SINGLE;
                        lastNode = atom;
                        ++this.nodeCounter;
                        this.position += this.currentSymbol.length();
                        bondExists = true;
                        this.bondIsAromatic = false;
                        break block44;
                    }
                    if (mychar == '=') {
                        ++this.position;
                        if (this.status == 2 || (smiles.charAt(this.position) < '0' || smiles.charAt(this.position) > '9') && smiles.charAt(this.position) != '%') {
                            this.bondStatus = CDKConstants.BONDORDER_DOUBLE;
                        } else {
                            this.bondStatusForRingClosure = CDKConstants.BONDORDER_DOUBLE;
                        }
                        break block44;
                    }
                    if (mychar == '#') {
                        ++this.position;
                        if (this.status == 2 || (smiles.charAt(this.position) < '0' || smiles.charAt(this.position) > '9') && smiles.charAt(this.position) != '%') {
                            this.bondStatus = CDKConstants.BONDORDER_TRIPLE;
                        } else {
                            this.bondStatusForRingClosure = CDKConstants.BONDORDER_TRIPLE;
                        }
                        break block44;
                    }
                    if (mychar == '(') {
                        atomStack.push(lastNode);
                        logger.debug("Stack:");
                        ses = atomStack.elements();
                        while (ses.hasMoreElements()) {
                            a = (IAtom)ses.nextElement();
                            logger.debug("", a.hashCode());
                        }
                        logger.debug("------");
                        bondStack.push(this.bondStatus);
                        ++this.position;
                        break block44;
                    }
                    if (mychar == ')') {
                        lastNode = (IAtom)atomStack.pop();
                        logger.debug("Stack:");
                        ses = atomStack.elements();
                        while (ses.hasMoreElements()) {
                            a = (IAtom)ses.nextElement();
                            logger.debug("", a.hashCode());
                        }
                        logger.debug("------");
                        this.bondStatus = (IBond.Order)((Object)bondStack.pop());
                        ++this.position;
                        break block44;
                    }
                    if (mychar >= '0' && mychar <= '9') {
                        this.status = 2;
                        chars[0] = mychar;
                        this.currentSymbol = new String(chars);
                        this.thisRing = Integer.valueOf(this.currentSymbol);
                        this.handleRing((IAtom)lastNode);
                        ++this.position;
                        break block44;
                    }
                    if (mychar == '%') {
                        this.currentSymbol = this.getRingNumber(smiles, this.position);
                        this.thisRing = Integer.valueOf(this.currentSymbol);
                        this.handleRing((IAtom)lastNode);
                        this.position += this.currentSymbol.length() + 1;
                        break block44;
                    }
                    if (mychar == '[') {
                        this.currentSymbol = this.getAtomString(smiles, this.position);
                        atom = this.assembleAtom(this.currentSymbol, (IAtom)lastNode, bondExists);
                        this.addAtomToActiveChiralities((IAtom)lastNode, atom);
                        this.molecule.addAtom(atom);
                        logger.debug("Added atom: ", atom);
                        if (lastNode != null && bondExists) {
                            bond = this.builder.newInstance(IBond.class, new Object[]{atom, lastNode, this.bondStatus});
                            if (this.bondIsAromatic) {
                                bond.setFlag(5, true);
                            }
                            this.molecule.addBond(bond);
                            logger.debug("Added bond: ", bond);
                        }
                        this.bondStatus = CDKConstants.BONDORDER_SINGLE;
                        this.bondIsAromatic = false;
                        lastNode = atom;
                        ++this.nodeCounter;
                        this.position = this.position + this.currentSymbol.length() + 2;
                        atom.setProperty(HAS_HARDCODED_HYDROGEN_COUNT, "yes");
                        if (atom.getImplicitHydrogenCount() == null) {
                            atom.setImplicitHydrogenCount(0);
                        }
                        bondExists = true;
                        break block44;
                    }
                    if (mychar == '.') {
                        bondExists = false;
                        ++this.position;
                        break block44;
                    }
                    if (mychar == '-') {
                        bondExists = true;
                        ++this.position;
                        break block44;
                    }
                    if (mychar == ':') {
                        bondExists = true;
                        this.bondIsAromatic = true;
                        ++this.position;
                        break block44;
                    }
                    if (mychar == '/' || mychar == '\\') {
                        logger.warn("Ignoring stereo information for double bond");
                        ++this.position;
                        break block44;
                    }
                    if (mychar == '@') {
                        TemporaryChiralityStorage chirality = null;
                        chirality = lastNode != null ? new TemporaryChiralityStorage((IAtom)lastNode) : new TemporaryChiralityStorage();
                        if (this.position < smiles.length() - 1 && smiles.charAt(this.position + 1) == '@') {
                            chirality.chiralityValue = Chirality.CLOCKWISE;
                            ++this.position;
                        } else {
                            chirality.chiralityValue = Chirality.ANTI_CLOCKWISE;
                        }
                        if (this.position < smiles.length() - 1 && smiles.charAt(this.position + 1) == 'H') {
                            IAtom hydrogen = this.builder.newInstance(IAtom.class, "H");
                            IBond newBond = this.builder.newInstance(IBond.class, new Object[]{atom, hydrogen, IBond.Order.SINGLE});
                            this.molecule.addAtom(hydrogen);
                            this.molecule.addBond(newBond);
                            chirality.addAtom(hydrogen);
                            ++this.position;
                        }
                        this.chiralityInfo.put((IAtom)lastNode, chirality);
                        ++this.position;
                        break block44;
                    }
                    throw new InvalidSmilesException("Unexpected character found: " + mychar);
                }
                catch (InvalidSmilesException exc) {
                    logger.error("InvalidSmilesException while parsing char (in parseSmiles()) '" + mychar + "': " + exc.getMessage());
                    logger.debug(exc);
                    throw exc;
                }
                catch (Exception exception) {
                    logger.error("Error while parsing char '" + mychar + "': " + exception.getMessage());
                    logger.debug(exception);
                    throw new InvalidSmilesException("Error while parsing char: " + mychar, exception);
                }
            }
            logger.debug("Parsing next char");
        } while (this.position < smiles.length());
        if (this.thisRing != -1 && this.ringbonds[this.thisRing] != null && this.rings[this.thisRing] != null) {
            throw new InvalidSmilesException("Rings weren't properly closed. Check ring numbers");
        }
        return this.molecule;
    }

    private String getAtomString(String smiles, int pos) throws InvalidSmilesException {
        logger.debug("getAtomString()");
        StringBuffer atomString = new StringBuffer();
        try {
            char character;
            for (int f = pos + 1; f < smiles.length() && (character = smiles.charAt(f)) != ']'; ++f) {
                atomString.append(character);
            }
        }
        catch (Exception exception) {
            String message = "Problem parsing Atom specification given in brackets.\n";
            message = message + "Invalid SMILES string was: " + smiles;
            logger.error(message);
            logger.debug(exception);
            throw new InvalidSmilesException(message, exception);
        }
        return atomString.toString();
    }

    private int getCharge(String chargeString, int position) {
        logger.debug("getCharge(): Parsing charge from: ", chargeString.substring(position));
        int charge = 0;
        if (chargeString.charAt(position) == '+') {
            charge = 1;
            ++position;
        } else if (chargeString.charAt(position) == '-') {
            charge = -1;
            ++position;
        } else {
            return charge;
        }
        StringBuffer multiplier = new StringBuffer();
        while (position < chargeString.length() && Character.isDigit(chargeString.charAt(position))) {
            multiplier.append(chargeString.charAt(position));
            ++position;
        }
        if (multiplier.length() > 0) {
            logger.debug("Found multiplier: ", multiplier);
            try {
                charge *= Integer.parseInt(multiplier.toString());
            }
            catch (Exception exception) {
                logger.error("Could not parse positive atomic charge!");
                logger.debug(exception);
            }
        }
        logger.debug("Found charge: ", charge);
        return charge;
    }

    private int getImplicitHydrogenCount(String s, int position) {
        logger.debug("getImplicitHydrogenCount(): Parsing implicit hydrogens from: " + s);
        int count = 0;
        if (s.charAt(position) == 'H') {
            StringBuffer multiplier = new StringBuffer();
            while (position < s.length() - 1 && Character.isDigit(s.charAt(position + 1))) {
                multiplier.append(s.charAt(position + 1));
                ++position;
            }
            if (multiplier.length() > 0) {
                try {
                    count = Integer.parseInt(multiplier.toString());
                }
                catch (Exception exception) {
                    logger.error("Could not parse number of implicit hydrogens from the multiplier: " + multiplier);
                    logger.debug(exception);
                }
            } else {
                count = -1;
            }
        }
        return count;
    }

    private String getElementSymbol(String s, int pos) {
        String possibleSymbol;
        logger.debug("getElementSymbol(): Parsing element symbol (pos=" + pos + ") from: " + s);
        if (pos < s.length() - 1) {
            possibleSymbol = ("" + s.charAt(pos)).toUpperCase() + s.charAt(pos + 1);
            logger.debug("possibleSymbol: ", possibleSymbol);
            if (PeriodicTable.getAtomicNumber(possibleSymbol) != null) {
                return possibleSymbol;
            }
        }
        possibleSymbol = s.substring(pos, pos + 1);
        logger.debug("possibleSymbol: ", possibleSymbol);
        if ("HKUVYW".indexOf(possibleSymbol) >= 0) {
            return possibleSymbol;
        }
        return this.getSymbolForOrganicSubsetElement(s, pos);
    }

    private void addAtomToActiveChiralities(IAtom chiAtom, IAtom atom) {
        for (IAtom chiralAtom : this.chiralityInfo.keySet()) {
            if (chiralAtom == atom || chiAtom != chiralAtom) continue;
            TemporaryChiralityStorage chirality = this.chiralityInfo.get(chiralAtom);
            if (chirality.counter >= 4) continue;
            chirality.addAtom(atom);
        }
    }

    private String getSymbolForOrganicSubsetElement(String s, int pos) {
        String possibleSymbol;
        logger.debug("getSymbolForOrganicSubsetElement(): Parsing organic subset element from: ", s);
        if (pos < s.length() - 1 && "ClBr".indexOf(possibleSymbol = s.substring(pos, pos + 2)) >= 0) {
            return possibleSymbol;
        }
        if ("BbCcNnOoFPSsI".indexOf(s.charAt(pos)) >= 0) {
            return s.substring(pos, pos + 1);
        }
        if ("fpi".indexOf(s.charAt(pos)) >= 0) {
            logger.warn("Element ", s, " is normally not sp2 hybridisized!");
            return s.substring(pos, pos + 1);
        }
        logger.warn("Subset element not found!");
        return null;
    }

    private String getRingNumber(String s, int pos) throws InvalidSmilesException {
        logger.debug("getRingNumber()");
        if (++pos >= s.length() - 1) {
            throw new InvalidSmilesException("Percent sign ring closure numbers must be two-digit.");
        }
        String retString = s.substring(pos, pos + 2);
        if (retString.charAt(0) < '0' || retString.charAt(0) > '9' || retString.charAt(1) < '0' || retString.charAt(1) > '9') {
            throw new InvalidSmilesException("Percent sign ring closure numbers must be two-digit.");
        }
        return retString;
    }

    private IAtom assembleAtom(String s, IAtom lastNode, boolean bondExists) throws InvalidSmilesException {
        char mychar;
        logger.debug("assembleAtom(): Assembling atom from: ", s);
        IAtom atom = null;
        int position = 0;
        String currentSymbol = null;
        StringBuffer isotopicNumber = new StringBuffer();
        logger.debug("Parse everythings before and including element symbol");
        do {
            try {
                mychar = s.charAt(position);
                logger.debug("Parsing char: " + mychar);
                if (mychar >= 'A' && mychar <= 'Z' || mychar >= 'a' && mychar <= 'z') {
                    currentSymbol = this.getElementSymbol(s, position);
                    if (currentSymbol == null) {
                        throw new InvalidSmilesException("Expected element symbol, found " + mychar + "!");
                    }
                    logger.debug("Found element symbol: ", currentSymbol);
                    position += currentSymbol.length();
                    if (Character.isLowerCase(mychar)) {
                        if (currentSymbol.length() == 1) {
                            currentSymbol = currentSymbol.toUpperCase();
                        }
                        atom = this.builder.newInstance(IAtom.class, currentSymbol);
                        atom.setHybridization(IAtomType.Hybridization.SP2);
                        Integer hcount = atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
                        if (hcount > 0) {
                            atom.setImplicitHydrogenCount(hcount - 1);
                        }
                        if (this.preservingAromaticity) {
                            atom.setFlag(5, true);
                        }
                    } else {
                        atom = this.builder.newInstance(IAtom.class, currentSymbol);
                    }
                    logger.debug("Made atom: ", atom);
                    break;
                }
                if (mychar >= '0' && mychar <= '9') {
                    isotopicNumber.append(mychar);
                    continue;
                }
                if (mychar == '*') {
                    currentSymbol = "*";
                    atom = this.builder.newInstance(IPseudoAtom.class, currentSymbol);
                    logger.debug("Made atom: ", atom);
                    ++position;
                    break;
                }
                throw new InvalidSmilesException("Found unexpected char: " + mychar);
            }
            catch (InvalidSmilesException exc) {
                logger.error("InvalidSmilesException while parsing atom string '" + s + "': " + exc.getMessage());
                logger.debug(exc);
                throw exc;
            }
            catch (Exception exception) {
                logger.error("Could not parse atom string: ", s);
                logger.debug(exception);
                throw new InvalidSmilesException("Could not parse atom string '" + s + "': " + exception.getMessage(), exception);
            }
        } while (++position < s.length());
        if (isotopicNumber.toString().length() > 0) {
            try {
                atom.setMassNumber(Integer.parseInt(isotopicNumber.toString()));
            }
            catch (Exception exception) {
                logger.error("Could not set atom's isotope number '" + isotopicNumber + "'");
                logger.debug(exception);
            }
        }
        logger.debug("Parsing part after element symbol (like charge): ", s.substring(position));
        int charge = 0;
        int implicitHydrogens = 0;
        while (position < s.length()) {
            try {
                mychar = s.charAt(position);
                logger.debug("Parsing char: " + mychar);
                if (mychar == 'H') {
                    implicitHydrogens = this.getImplicitHydrogenCount(s, position);
                    ++position;
                    if (implicitHydrogens >= 0) {
                        ++position;
                    }
                    if (implicitHydrogens == -1) {
                        implicitHydrogens = 1;
                    }
                    atom.setImplicitHydrogenCount(implicitHydrogens);
                    continue;
                }
                if (mychar == '+' || mychar == '-') {
                    charge = this.getCharge(s, position);
                    ++position;
                    while (position < s.length() && Character.isDigit(s.charAt(position))) {
                        ++position;
                    }
                    atom.setFormalCharge(charge);
                    continue;
                }
                if (mychar == '@') {
                    TemporaryChiralityStorage chirality = null;
                    chirality = lastNode != null && bondExists ? new TemporaryChiralityStorage(lastNode) : new TemporaryChiralityStorage();
                    if (position < s.length() - 1 && s.charAt(position + 1) == '@') {
                        chirality.chiralityValue = Chirality.CLOCKWISE;
                        ++position;
                    } else {
                        chirality.chiralityValue = Chirality.ANTI_CLOCKWISE;
                    }
                    if (position < s.length() - 1 && s.charAt(position + 1) == 'H') {
                        IAtom hydrogen = this.builder.newInstance(IAtom.class, "H");
                        IBond newBond = this.builder.newInstance(IBond.class, new Object[]{atom, hydrogen, IBond.Order.SINGLE});
                        this.molecule.addAtom(hydrogen);
                        this.molecule.addBond(newBond);
                        chirality.addAtom(hydrogen);
                        ++position;
                    }
                    this.chiralityInfo.put(atom, chirality);
                    ++position;
                    continue;
                }
                throw new InvalidSmilesException("Found unexpected char: " + mychar);
            }
            catch (InvalidSmilesException exc) {
                logger.error("InvalidSmilesException while parsing atom string: ", s);
                logger.debug(exc);
                throw exc;
            }
            catch (Exception exception) {
                logger.error("Could not parse atom string: ", s);
                logger.debug(exception);
                throw new InvalidSmilesException("Could not parse atom string: " + s, exception);
            }
        }
        return atom;
    }

    private void handleRing(IAtom atom) {
        logger.debug("handleRing():");
        IBond.Order bondStat = this.bondStatusForRingClosure;
        if (BondManipulator.isHigherOrder(this.ringbonds[this.thisRing], bondStat)) {
            bondStat = this.ringbonds[this.thisRing];
        }
        IBond bond = null;
        IAtom partner = null;
        IAtom thisNode = this.rings[this.thisRing];
        IAtom templateAtom = this.ringOtherAtoms[this.thisRing];
        if (thisNode != null) {
            partner = thisNode;
            this.replaceTemplateAtomInStereos(templateAtom, atom);
            if (this.chiralityInfo.containsKey(atom)) {
                this.addAtomToActiveChiralities(atom, partner);
            }
            bond = this.builder.newInstance(IBond.class, new Object[]{atom, partner, bondStat});
            if (this.bondIsAromatic) {
                bond.setFlag(5, true);
            }
            this.molecule.addBond(bond);
            this.bondIsAromatic = false;
            this.rings[this.thisRing] = null;
            this.ringbonds[this.thisRing] = null;
            this.ringOtherAtoms[this.thisRing] = null;
        } else {
            this.rings[this.thisRing] = atom;
            this.ringOtherAtoms[this.thisRing] = this.builder.newInstance(IAtom.class, new Object[0]);
            this.addAtomToActiveChiralities(atom, this.ringOtherAtoms[this.thisRing]);
            this.ringbonds[this.thisRing] = this.bondStatusForRingClosure;
        }
        this.bondStatusForRingClosure = IBond.Order.SINGLE;
    }

    private void replaceTemplateAtomInStereos(IAtom templateAtom, IAtom atom) {
        for (TemporaryChiralityStorage chirality : this.chiralityInfo.values()) {
            for (int i = 0; i < 4; ++i) {
                if (chirality.atoms[i] != templateAtom) continue;
                chirality.atoms[i] = atom;
            }
        }
    }

    private void addImplicitHydrogens(IMolecule container) {
        try {
            logger.debug("before H-adding: ", container);
            for (IAtom nextAtom : container.atoms()) {
                if (nextAtom.getProperty(HAS_HARDCODED_HYDROGEN_COUNT) != null) continue;
                this.hAdder.addImplicitHydrogens(container, nextAtom);
            }
            logger.debug("after H-adding: ", container);
        }
        catch (Exception exception) {
            logger.error("Error while calculation Hcount for SMILES atom: ", exception.getMessage());
        }
    }

    private void perceiveAromaticity(IMolecule m) {
        IMoleculeSet moleculeSet = ConnectivityChecker.partitionIntoMolecules(m);
        logger.debug("#mols ", moleculeSet.getAtomContainerCount());
        for (int i = 0; i < moleculeSet.getAtomContainerCount(); ++i) {
            IAtomContainer molecule = moleculeSet.getAtomContainer(i);
            logger.debug("mol: ", molecule);
            try {
                logger.debug(" after saturation: ", molecule);
                if (!CDKHueckelAromaticityDetector.detectAromaticity(molecule)) continue;
                logger.debug("Structure is aromatic...");
                continue;
            }
            catch (Exception exception) {
                logger.error("Could not perceive aromaticity: ", exception.getMessage());
                logger.debug(exception);
            }
        }
    }

    public void setPreservingAromaticity(boolean preservingAromaticity) {
        this.preservingAromaticity = preservingAromaticity;
    }

    public boolean isPreservingAromaticity() {
        return this.preservingAromaticity;
    }

    class TemporaryChiralityStorage {
        Chirality chiralityValue = null;
        IAtom[] atoms = new IAtom[4];
        int counter;

        public TemporaryChiralityStorage() {
            this.counter = 0;
        }

        public TemporaryChiralityStorage(IAtom atom) {
            this.atoms[0] = atom;
            this.counter = 1;
        }

        public void addAtom(IAtom atom) {
            this.atoms[this.counter] = atom;
            ++this.counter;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Chirality {
        ANTI_CLOCKWISE,
        CLOCKWISE;

    }
}

