/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.BoundsCalculator;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.TextElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.renderer.generators.ReactionPlusGeneratorTest")
public class ReactionPlusGenerator
implements IGenerator<IReaction> {
    @Override
    @TestMethod(value="testEmptyReaction")
    public IRenderingElement generate(IReaction reaction, RendererModel model) {
        IMoleculeSet products;
        double axis;
        ElementGroup diagram = new ElementGroup();
        Color color = (Color)model.getParameter(BasicSceneGenerator.ForegroundColor.class).getValue();
        IMoleculeSet reactants = reaction.getReactants();
        if (reactants.getAtomContainerCount() > 1) {
            Rectangle2D totalBoundsReactants = BoundsCalculator.calculateBounds(reactants);
            Rectangle2D bounds1 = BoundsCalculator.calculateBounds(reactants.getAtomContainer(0));
            axis = totalBoundsReactants.getCenterY();
            for (int i = 1; i < reaction.getReactantCount(); ++i) {
                Rectangle2D bounds2 = BoundsCalculator.calculateBounds(reactants.getAtomContainer(i));
                diagram.add(this.makePlus(bounds1, bounds2, axis, color));
                bounds1 = bounds2;
            }
        }
        if ((products = reaction.getProducts()).getAtomContainerCount() > 1) {
            Rectangle2D totalBoundsProducts = BoundsCalculator.calculateBounds(products);
            axis = totalBoundsProducts.getCenterY();
            Rectangle2D bounds1 = BoundsCalculator.calculateBounds(reactants.getAtomContainer(0));
            for (int i = 1; i < reaction.getProductCount(); ++i) {
                Rectangle2D bounds2 = BoundsCalculator.calculateBounds(products.getAtomContainer(i));
                diagram.add(this.makePlus(bounds1, bounds2, axis, color));
                bounds1 = bounds2;
            }
        }
        return diagram;
    }

    private TextElement makePlus(Rectangle2D moleculeBox1, Rectangle2D moleculeBox2, double axis, Color color) {
        double arrowCenter = (moleculeBox1.getCenterX() + moleculeBox2.getCenterX()) / 2.0;
        return new TextElement(arrowCenter, axis, "+", color);
    }

    @Override
    @TestMethod(value="testGetParameters")
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(new IGeneratorParameter[0]);
    }
}

