/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondIterator;

class BondIteratorSelected
implements BondIterator {
    private Bond[] bonds;
    private int bondCount;
    private int bondType;
    private int iBond;
    private BitSet bsSelected;
    private boolean bondSelectionModeOr;
    private boolean isBondBitSet;

    BondIteratorSelected(Bond[] bondArray, int n, int n2, BitSet bitSet, boolean bl) {
        this.bonds = bondArray;
        this.bondCount = n;
        this.bondType = n2;
        this.bsSelected = bitSet;
        this.bondSelectionModeOr = bl;
        this.isBondBitSet = false;
        this.iBond = 0;
    }

    BondIteratorSelected(Bond[] bondArray, int n, BitSet bitSet) {
        this.bonds = bondArray;
        this.bondCount = n;
        this.bsSelected = bitSet;
        this.isBondBitSet = true;
        this.iBond = 0;
    }

    public boolean hasNext() {
        if (this.isBondBitSet) {
            this.iBond = this.bsSelected.nextSetBit(this.iBond);
            return this.iBond >= 0 && this.iBond < this.bondCount;
        }
        while (this.iBond < this.bondCount) {
            Bond bond = this.bonds[this.iBond];
            if (!(this.bondType != 65535 && (bond.order & this.bondType) == 0 || this.bondType == 65535 && (bond.order & 0x8000) != 0)) {
                boolean bl = this.bsSelected.get(bond.atom1.index);
                boolean bl2 = this.bsSelected.get(bond.atom2.index);
                if (!this.bondSelectionModeOr && bl && bl2 || this.bondSelectionModeOr && (bl || bl2)) {
                    return true;
                }
            }
            ++this.iBond;
        }
        return false;
    }

    public int nextIndex() {
        return this.iBond;
    }

    public Bond next() {
        return this.bonds[this.iBond++];
    }
}

