/*
 * Decompiled with CFR 0.152.
 */
package ambit2.base.config;

import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class Preferences {
    protected static PropertyChangeSupport propertyChangeSupport;
    public static String FASTSMARTS;
    public static String SHOW_AROMATICITY;
    public static String GENERATE2D;
    public static String DEFAULT_DIR;
    public static String START_MYSQL;
    public static String MAXRECORDS;
    public static String SMILESPARSER;
    public static String STOP_AT_UNKNOWNATOMTYPES;
    public static String MOPAC_DIR;
    public static String MOPAC_EXE;
    public static String MENGINE_WIN;
    public static String MENGINE_LINUX;
    public static String OPENBABEL_WIN;
    public static String OPENBABEL_LINUX;
    public static String SMI2SDF_WIN;
    public static String SMI2SDF_LINUX;
    public static String SMILES_FIELD;
    public static String SMILES_GEN;
    public static String SCHEME;
    public static String DATABASE;
    public static String HOST;
    public static String PORT;
    public static String USER;
    public static String PASSWORD;
    public static String TIMEOUT;
    public static String REMOTELOOKUP;
    public static String REMOTELOOKUP_URI;
    protected static final String filename = "ambit2.pref";
    protected static Properties props;
    public static Object[][] default_values;

    protected static Properties getDefault() {
        Properties properties = new Properties();
        for (int i = 0; i < default_values.length; ++i) {
            properties.setProperty(default_values[i][0].toString(), default_values[i][2].toString());
        }
        return properties;
    }

    protected static Properties loadProperties() throws IOException {
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(new File(filename));
        properties.load(fileInputStream);
        ((InputStream)fileInputStream).close();
        return properties;
    }

    public static Properties getProperties() {
        if (props == null) {
            try {
                props = Preferences.loadProperties();
                if (props.size() == 0) {
                    props = Preferences.getDefault();
                }
                propertyChangeSupport = new PropertyChangeSupport(props);
            }
            catch (Exception exception) {
                props = Preferences.getDefault();
                propertyChangeSupport = new PropertyChangeSupport(props);
            }
        }
        return props;
    }

    public static void saveProperties(String string) throws IOException {
        if (props == null) {
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(new File(filename));
        props.store(fileOutputStream, string);
        ((OutputStream)fileOutputStream).close();
    }

    public static void setProperty(String string, String string2) {
        Properties properties = Preferences.getProperties();
        String string3 = properties.getProperty(string);
        properties.put(string, string2);
        propertyChangeSupport.firePropertyChange(string, string3, string2);
    }

    public static String getProperty(String string) {
        Properties properties = Preferences.getProperties();
        Object object = properties.get(string);
        if (object == null) {
            Properties properties2 = Preferences.getDefault();
            object = properties2.get(string);
            if (object == null) {
                object = "";
            }
            Preferences.setProperty(string, object.toString());
        }
        return object.toString();
    }

    public static PropertyChangeSupport getPropertyChangeSupport() {
        if (propertyChangeSupport == null) {
            Preferences.getProperties();
        }
        return propertyChangeSupport;
    }

    public static void setPropertyChangeSupport(PropertyChangeSupport propertyChangeSupport) {
        Preferences.propertyChangeSupport = propertyChangeSupport;
    }

    static {
        FASTSMARTS = "FASTSMARTS";
        SHOW_AROMATICITY = "showAromaticity";
        GENERATE2D = "generate2D";
        DEFAULT_DIR = "defaultDir";
        START_MYSQL = "startMySQL";
        MAXRECORDS = "MAXRECORDS";
        SMILESPARSER = "smilesParser";
        STOP_AT_UNKNOWNATOMTYPES = "atomtypes.stop";
        MOPAC_DIR = "mopac.dir";
        MOPAC_EXE = "mopac.exe";
        MENGINE_WIN = "mengine.win";
        MENGINE_LINUX = "mengine.linux";
        OPENBABEL_WIN = "obabel.win";
        OPENBABEL_LINUX = "obabel.linux";
        SMI2SDF_WIN = "smi2sdf.win";
        SMI2SDF_LINUX = "smi2sdf.linux";
        SMILES_FIELD = "SMILES";
        SMILES_GEN = "smi2sdf.smiles.generate";
        SCHEME = "Scheme";
        DATABASE = "Database";
        HOST = "Host";
        PORT = "Port";
        USER = "User";
        PASSWORD = "Password";
        TIMEOUT = "timeout";
        REMOTELOOKUP = "remotelookup";
        REMOTELOOKUP_URI = "remotelookup_uri";
        props = null;
        default_values = new Object[][]{{DATABASE, "Default database schema", "ambit2", String.class, "This is the default database schema AmbitXT will attempt to connect to when a database connection is required.", false, VTAGS.Database}, {PORT, "Default database port", "3306", String.class, "This is the default port AmbitXT will attempt to connect with when a database connection is required. It is assumed MySQL server runs on this port.", false, VTAGS.Database}, {USER, "Default user", "guest", String.class, "This is the default user name AmbitXT will attempt to connect with when a database connection is required.", false, VTAGS.Database}, {HOST, "Host", "localhost", String.class, "This is the default host AmbitXT will attempt to connect with when a database connection is required. It is assumed MySQL server runs on this host.", false, VTAGS.Database}, {SCHEME, "Scheme", "jdbc:mysql", String.class, "", true, VTAGS.Database}, {START_MYSQL, "Start MySQL automatically", "true", Boolean.class, "If checked, the embedded MySQL server will be automatically started upon application launch", false, VTAGS.Database}, {MAXRECORDS, "Maximum number of records", 2000, String.class, "Maximum number of records to be returned by a search query", false, VTAGS.Database}, {TIMEOUT, "Timeout for search results, ms", 60000, String.class, "Timeout of search queries, in milliseconds ", false, VTAGS.Database}, {FASTSMARTS, "Use SMARTS accelerator", "true", Boolean.class, "Accelerate SMARTS search", false, VTAGS.Structure}, {SHOW_AROMATICITY, "Show circle in an aromatic ring", "true", Boolean.class, "Toggles displaying aromatic rings", true, VTAGS.Structure}, {REMOTELOOKUP, "Remote lookup enabled", "false", Boolean.class, "Enable remote lookup for CAS and EINECS", false, VTAGS.RemoteQuery}, {REMOTELOOKUP_URI, "Remote lookup URI", "http://apps.ideaconsult.net:8080/ambit2/query/compound/search/all?search=%s&max=1&media=chemical%%2Fx-mdl-sdfile", String.class, "OpenTox web service address for compound lookup", false, VTAGS.RemoteQuery}, {GENERATE2D, "Generate 2d coordinates if none exist", "true", Boolean.class, "Generate 2D coordinates of the structures, entered as SMILES", false, VTAGS.Structure}, {SMILESPARSER, "Use Openbabel SMILES parser", "true", Boolean.class, "Toggles usage of Openbabel vs. CDK SMILES parser. Openbabel available at http://openbabel.org/", false, VTAGS.Structure}, {STOP_AT_UNKNOWNATOMTYPES, "Stop at unknown atom types", "false", Boolean.class, "If checked, will report an error when an unknown atom type is encountered.", false, VTAGS.Structure}, {DEFAULT_DIR, "Default directory", "", String.class, "This folder will appear as a default in the file open or file save dialogs", false, VTAGS.General}, {SMILES_GEN, "Generate the smiles submitted to smi2sdf", "true", Boolean.class, "Generate the smiles , submitted to smi2sdf, or use the one in the file", true, VTAGS.Conversion3D}};
    }

    public static enum VINDEX {
        NAME,
        TITLE,
        VALUE,
        CLASS,
        HINT,
        HIDDEN,
        TAG;

    }

    public static enum VTAGS {
        General,
        Structure,
        Conversion3D,
        Database,
        RemoteQuery;

    }
}

