/*
 * Decompiled with CFR 0.152.
 */
package libpadeljobs;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import libpadeljobs.Job;
import libpadeljobs.Master;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Worker<J extends Job>
extends Thread {
    protected boolean toStop = false;
    protected LinkedBlockingQueue<J> jobsWaiting;
    protected LinkedBlockingQueue<J> jobsRunning;
    protected LinkedBlockingQueue<J> jobsCompleted;
    protected J job;

    public Worker(LinkedBlockingQueue<J> jobsWaiting, LinkedBlockingQueue<J> jobsRunning, LinkedBlockingQueue<J> jobsCompleted) {
        this.jobsWaiting = jobsWaiting;
        this.jobsRunning = jobsRunning;
        this.jobsCompleted = jobsCompleted;
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.job = (Job)this.jobsWaiting.take();
                if (!this.toStop && ((Job)this.job).getId() != Master.NO_MORE_JOBS) {
                    ((Job)this.job).setStarttime(System.nanoTime());
                    this.jobsRunning.add(this.job);
                    this.DoJob();
                    ((Job)this.job).setEndtime(System.nanoTime());
                    this.jobsRunning.remove(this.job);
                    this.jobsCompleted.add(this.job);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger("global").log(Level.SEVERE, Integer.toString(((Job)this.job).getId()), ex);
        }
    }

    public void StopWorker() {
        this.toStop = true;
    }

    public abstract void DoJob();
}

