/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io.bcf;

import ambit2.base.data.ILiteratureEntry;
import ambit2.base.data.LiteratureEntry;
import ambit2.base.data.Property;
import ambit2.core.io.IteratingXLSReader;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;

public class EurasBCFReader
extends IteratingXLSReader {
    protected Hashtable<Double, LiteratureEntry> references;

    public EurasBCFReader(InputStream inputStream, int n) throws CDKException {
        super(inputStream, n);
        this.setNumberOfHeaderLines(2);
        this.references = new Hashtable();
    }

    protected void readReferences() {
        HSSFSheet hSSFSheet = this.workbook.getSheetAt(1);
        Iterator iterator = hSSFSheet.rowIterator();
        while (iterator.hasNext()) {
            HSSFRow hSSFRow = (HSSFRow)iterator.next();
            if (hSSFRow.getRowNum() == 0) continue;
            Double d = hSSFRow.getCell(0).getNumericCellValue();
            LiteratureEntry literatureEntry = this.getCitation(hSSFRow);
            if (literatureEntry == null) continue;
            this.references.put(d, literatureEntry);
        }
    }

    protected LiteratureEntry getCitation(HSSFRow hSSFRow) {
        return LiteratureEntry.getInstance((String)String.format("%s,\"%s\" %s %d-%s (%d): %s.", this.getAuthor(hSSFRow), this.getTitle(hSSFRow), this.getJournal(hSSFRow), this.getVolume(hSSFRow), this.getIssue(hSSFRow), this.getYear(hSSFRow), this.getPages(hSSFRow)), (String)this.getJournal(hSSFRow));
    }

    protected String getAuthor(HSSFRow hSSFRow) {
        return hSSFRow.getCell(1).getStringCellValue();
    }

    protected String getTitle(HSSFRow hSSFRow) {
        return hSSFRow.getCell(2).getStringCellValue();
    }

    protected String getJournal(HSSFRow hSSFRow) {
        return hSSFRow.getCell(3).getStringCellValue();
    }

    protected int getYear(HSSFRow hSSFRow) {
        Double d = hSSFRow.getCell(4).getNumericCellValue();
        return d.intValue();
    }

    protected int getVolume(HSSFRow hSSFRow) {
        Double d = hSSFRow.getCell(5).getNumericCellValue();
        return d.intValue();
    }

    protected String getIssue(HSSFRow hSSFRow) {
        if (hSSFRow.getCell(6) == null) {
            return "";
        }
        return Integer.toString(Double.valueOf(hSSFRow.getCell(6).getNumericCellValue()).intValue());
    }

    protected String getPages(HSSFRow hSSFRow) {
        try {
            return hSSFRow.getCell(7).getStringCellValue();
        }
        catch (Exception exception) {
            return Integer.toString(Double.valueOf(hSSFRow.getCell(7).getNumericCellValue()).intValue());
        }
    }

    @Override
    public void processHeader() {
        this.iterator = this.sheet.rowIterator();
        this.processHeader((HSSFRow)this.iterator.next());
        HSSFRow hSSFRow = (HSSFRow)this.iterator.next();
        for (int i = 0; i < this.getNumberOfColumns(); ++i) {
            HSSFCell hSSFCell = hSSFRow.getCell(i);
            if (hSSFCell == null) continue;
            ((Property)this.getHeaderColumn(i)).setUnits(hSSFCell.getStringCellValue());
        }
        this.readReferences();
    }

    @Override
    protected void processRow(IAtomContainer iAtomContainer) {
        Object object = iAtomContainer.getProperty((Object)Property.getInstance((String)"ref", (ILiteratureEntry)this.getReference()));
        try {
            Double d = (Double)object;
            iAtomContainer.setProperty((Object)"REFERENCE", (Object)this.references.get(d));
        }
        catch (Exception exception) {
            iAtomContainer.setProperty((Object)"REFERENCE", (Object)LiteratureEntry.getInstance((String)object.toString(), (String)object.toString()));
        }
    }
}

