/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.base.data.Profile;
import ambit2.base.data.Property;
import org.openscience.cdk.io.ReaderEvent;
import org.openscience.cdk.io.listener.IReaderListener;
import org.openscience.cdk.io.listener.IWriterListener;
import org.openscience.cdk.io.setting.IOSetting;

public class SimpleIOListener
implements IReaderListener,
IWriterListener {
    protected int level;
    protected Profile properties;
    protected int counter = 0;

    public SimpleIOListener(int n) {
        this.level = n;
        this.properties = new Profile();
    }

    public void processIOSettingQuestion(IOSetting iOSetting) {
        this.selectProperties(iOSetting);
    }

    protected void selectProperties(IOSetting iOSetting) {
        Property.IO_QUESTION iO_QUESTION = Property.IO_QUESTION.valueOf((String)iOSetting.getQuestion());
        switch (iO_QUESTION) {
            case IO_START: {
                this.counter = 0;
            }
            case IO_STOP: {
                if (this.counter > 0 && iOSetting.getLevel() <= this.level) {
                    this.onStopEvent();
                }
            }
            case IO_TRANSLATE_NAME: {
                if ("".equals(iOSetting.getName().trim())) break;
                Property property = Property.getInstance((String)iOSetting.getName(), (String)"I/O");
                property.setLabel(iOSetting.getDefaultSetting());
                property.setOrder(this.counter);
                if (iOSetting.getLevel() > this.level) {
                    property.setEnabled(true);
                }
                this.properties.add(property);
                ++this.counter;
            }
        }
    }

    protected void onStopEvent() {
    }

    public void frameRead(ReaderEvent readerEvent) {
    }

    public Profile getProperties() {
        return this.properties;
    }

    public void setProperties(Profile profile) {
        this.properties = profile;
    }
}

