/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.smiles;

import ambit2.base.config.Preferences;
import ambit2.base.external.ShellException;
import ambit2.core.smiles.DeduceBondSystemTool;
import ambit2.core.smiles.OpenBabelShell;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smiles.SmilesParser;

public class SmilesParserWrapper
implements PropertyChangeListener {
    protected OpenBabelShell babel = null;
    protected SmilesParser cdkParser = null;
    protected DeduceBondSystemTool dbt;
    protected SMILES_PARSER parser = SMILES_PARSER.OPENBABEL;

    protected SmilesParserWrapper() {
        this("true".equals(Preferences.getProperty((String)Preferences.SMILESPARSER)) ? SMILES_PARSER.OPENBABEL : SMILES_PARSER.CDK);
    }

    protected SmilesParserWrapper(SMILES_PARSER sMILES_PARSER) {
        this.setParser(sMILES_PARSER);
        this.dbt = new DeduceBondSystemTool();
    }

    public IMolecule parseSmiles(String string) throws InvalidSmilesException {
        return this.parseSmiles(string, true);
    }

    public IMolecule parseSmiles(String string, boolean bl) throws InvalidSmilesException {
        switch (this.parser) {
            case OPENBABEL: {
                try {
                    if (this.babel == null) {
                        this.babel = new OpenBabelShell();
                        this.babel.setHydrogens(bl);
                    }
                    return (IMolecule)this.babel.runShell(string);
                }
                catch (ShellException shellException) {
                    this.setParser(SMILES_PARSER.CDK);
                    if (this.cdkParser == null) {
                        this.cdkParser = new SmilesParser(SilentChemObjectBuilder.getInstance());
                    }
                    IMolecule iMolecule = this.cdkParser.parseSmiles(string);
                    try {
                        return this.dbt.fixAromaticBondOrders(iMolecule);
                    }
                    catch (CDKException cDKException) {
                        cDKException.printStackTrace();
                        return iMolecule;
                    }
                }
                catch (Exception exception) {
                    throw new InvalidSmilesException(exception.getMessage());
                }
            }
        }
        if (this.cdkParser == null) {
            this.cdkParser = new SmilesParser(SilentChemObjectBuilder.getInstance());
        }
        IMolecule iMolecule = this.cdkParser.parseSmiles(string);
        try {
            return this.dbt.fixAromaticBondOrders(iMolecule);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return iMolecule;
        }
    }

    public SMILES_PARSER getParser() {
        return this.parser;
    }

    public void setParser(SMILES_PARSER sMILES_PARSER) {
        this.parser = sMILES_PARSER;
    }

    public static SmilesParserWrapper getInstance(SMILES_PARSER sMILES_PARSER) {
        return new SmilesParserWrapper(sMILES_PARSER);
    }

    public static void returnInstance(SmilesParserWrapper smilesParserWrapper) {
        Preferences.getPropertyChangeSupport().removePropertyChangeListener(smilesParserWrapper);
        smilesParserWrapper = null;
    }

    public static SmilesParserWrapper getInstance() {
        return SmilesParserWrapper.getInstance("true".equals(Preferences.getProperty((String)Preferences.SMILESPARSER).toLowerCase()) ? SMILES_PARSER.OPENBABEL : SMILES_PARSER.CDK);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            this.setParser("true".equals(Preferences.getProperty((String)Preferences.SMILESPARSER).toLowerCase()) ? SMILES_PARSER.OPENBABEL : SMILES_PARSER.CDK);
        }
        catch (Exception exception) {
            this.setParser(SMILES_PARSER.OPENBABEL);
        }
    }

    protected void finalize() throws Throwable {
        this.dbt = null;
        this.babel = null;
        this.cdkParser = null;
        super.finalize();
    }

    public static enum SMILES_PARSER {
        CDK,
        OPENBABEL;

    }
}

