/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import libpadeldescriptor.AtomTypeAwareSaturationChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.RingPartitioner;
import org.openscience.cdk.ringsearch.SSSRFinder;

public class PaDELDearomatize {
    private PaDELDearomatize() {
    }

    public static IAtomContainer Dearomatize(IAtomContainer iAtomContainer) {
        IAtomContainer iAtomContainer2 = null;
        try {
            iAtomContainer2 = iAtomContainer.clone();
        }
        catch (Exception exception) {
            return iAtomContainer;
        }
        SSSRFinder sSSRFinder = new SSSRFinder(iAtomContainer2);
        IRingSet iRingSet = sSSRFinder.findEssentialRings();
        List<IRingSet> list = RingPartitioner.partitionRings(iRingSet);
        for (IRingSet iChemObject : list) {
            PaDELDearomatize.RemoveNonAromaticRings(iChemObject);
            if (!PaDELDearomatize.Dearomatize666Rings(iChemObject) && !PaDELDearomatize.Dearomatize566Rings(iChemObject) && !PaDELDearomatize.Dearomatize66Rings(iChemObject) && !PaDELDearomatize.Dearomatize56Rings(iChemObject) && !PaDELDearomatize.Dearomatize6Ring(iChemObject) && !PaDELDearomatize.Dearomatize5Ring(iChemObject)) continue;
        }
        for (IBond iBond : iAtomContainer2.bonds()) {
            if (!iBond.getFlag(5)) continue;
            iBond.setFlag(12, true);
        }
        try {
            new AtomTypeAwareSaturationChecker().decideBondOrder(iAtomContainer2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PaDELDearomatize.DearomatizeConjugation(iAtomContainer2);
        return iAtomContainer2;
    }

    private static boolean DearomatizeConjugation(IAtomContainer iAtomContainer) {
        IAtom iAtom = null;
        for (IAtom iAtom2 : iAtomContainer.atoms()) {
            if (!iAtom2.getFlag(5)) continue;
            iAtom = PaDELDearomatize.GetConjugatedStartAtom(iAtomContainer, iAtom2, null, new HashSet<IAtom>());
            if (PaDELDearomatize.CountConjugatedAtoms(iAtomContainer, iAtom, null, new HashSet<IAtom>(), 1) >= 3) break;
            iAtom = null;
            break;
        }
        if (iAtom != null) {
            PaDELDearomatize.ConvertConjugation(iAtomContainer, iAtom, null, false);
        }
        return true;
    }

    private static IAtom GetConjugatedStartAtom(IAtomContainer iAtomContainer, IAtom iAtom, IAtom iAtom2, Set<IAtom> set) {
        set.add(iAtom);
        List<IAtom> list = iAtomContainer.getConnectedAtomsList(iAtom);
        for (IAtom iAtom3 : list) {
            if (iAtom3 == iAtom2 || !iAtom3.getFlag(5)) continue;
            if (set.contains(iAtom3)) {
                return null;
            }
            return PaDELDearomatize.GetConjugatedStartAtom(iAtomContainer, iAtom3, iAtom, set);
        }
        return iAtom;
    }

    private static int CountConjugatedAtoms(IAtomContainer iAtomContainer, IAtom iAtom, IAtom iAtom2, Set<IAtom> set, int n) {
        set.add(iAtom);
        List<IAtom> list = iAtomContainer.getConnectedAtomsList(iAtom);
        for (IAtom iAtom3 : list) {
            if (iAtom3 == iAtom2 || !iAtom3.getFlag(5)) continue;
            if (set.contains(iAtom3)) {
                return 0;
            }
            return PaDELDearomatize.CountConjugatedAtoms(iAtomContainer, iAtom3, iAtom, set, ++n);
        }
        return n;
    }

    private static void ConvertConjugation(IAtomContainer iAtomContainer, IAtom iAtom, IAtom iAtom2, boolean bl) {
        iAtom.setFlag(5, false);
        if (iAtom.getAtomicNumber() == 8) {
            iAtom.setFormalCharge(0);
            iAtom.setHybridization(IAtomType.Hybridization.SP2);
            iAtom.setAtomTypeName("O.sp2");
        }
        List<IAtom> list = iAtomContainer.getConnectedAtomsList(iAtom);
        for (IAtom iAtom3 : list) {
            if (iAtom3 == iAtom2 || !iAtom3.getFlag(5)) continue;
            IBond iBond = iAtomContainer.getBond(iAtom, iAtom3);
            iBond.setFlag(5, false);
            if (bl) {
                iBond.setOrder(IBond.Order.SINGLE);
            } else {
                iBond.setOrder(IBond.Order.DOUBLE);
            }
            PaDELDearomatize.ConvertConjugation(iAtomContainer, iAtom3, iAtom, !bl);
            break;
        }
    }

    private static boolean DearomatizeAmide(IAtomContainer iAtomContainer) {
        for (IAtom iAtom : iAtomContainer.atoms()) {
            if (iAtom.getAtomicNumber() != 7) continue;
            List<IAtom> list = iAtomContainer.getConnectedAtomsList(iAtom);
            for (IAtom iAtom2 : list) {
                if (iAtom2.getAtomicNumber() != 6 || PaDELDearomatize.CountAttachedBonds(iAtomContainer, iAtom2, IBond.Order.DOUBLE, "O") != 1 || !iAtom.getFlag(5) || !iAtom2.getFlag(5) || !iAtomContainer.getBond(iAtom, iAtom2).getFlag(5)) continue;
                iAtom.setFlag(5, false);
                iAtom2.setFlag(5, false);
                iAtomContainer.getBond(iAtom, iAtom2).setFlag(5, false);
            }
        }
        return true;
    }

    private static int CountAttachedBonds(IAtomContainer iAtomContainer, IAtom iAtom, IBond.Order order, String string) {
        List<IBond> list = iAtomContainer.getConnectedBondsList(iAtom);
        int n = list.size();
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            IBond iBond = list.get(i);
            if (iBond.getOrder() != order || iBond.getAtomCount() != 2 || !iBond.contains(iAtom)) continue;
            if (string != null) {
                if ((iBond.getAtom(0) == iAtom || !iBond.getAtom(0).getSymbol().equals(string)) && (iBond.getAtom(1) == iAtom || !iBond.getAtom(1).getSymbol().equals(string))) continue;
                ++n2;
                continue;
            }
            ++n2;
        }
        return n2;
    }

    private static void RemoveNonAromaticRings(IRingSet iRingSet) {
        ArrayList<IAtomContainer> arrayList = new ArrayList<IAtomContainer>();
        for (IAtomContainer iAtomContainer : iRingSet.atomContainers()) {
            if (PaDELDearomatize.isAllAtomsAromatic(iAtomContainer)) continue;
            arrayList.add(iAtomContainer);
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            iRingSet.removeAtomContainer((IAtomContainer)arrayList.get(i));
        }
    }

    private static boolean Dearomatize666Rings(IRingSet iRingSet) {
        IAtomContainer iAtomContainer;
        IAtomContainer iAtomContainer2;
        IAtomContainer iAtomContainer3;
        if (iRingSet.getAtomContainerCount() != 3) {
            return false;
        }
        IAtomContainer iAtomContainer4 = iRingSet.getAtomContainer(0);
        if (PaDELDearomatize.isMiddleRing(iAtomContainer4, iAtomContainer3 = iRingSet.getAtomContainer(1), iAtomContainer2 = iRingSet.getAtomContainer(2))) {
            iAtomContainer = iAtomContainer3;
            iAtomContainer3 = iAtomContainer4;
            iAtomContainer4 = iAtomContainer;
        }
        if (PaDELDearomatize.isMiddleRing(iAtomContainer2, iAtomContainer4, iAtomContainer3)) {
            iAtomContainer = iAtomContainer3;
            iAtomContainer3 = iAtomContainer2;
            iAtomContainer2 = iAtomContainer;
        }
        int n = iAtomContainer4.getAtomCount();
        int n2 = iAtomContainer3.getAtomCount();
        int n3 = iAtomContainer2.getAtomCount();
        if (n != 6 || n2 != 6 || n3 != 6) {
            return false;
        }
        if (!(PaDELDearomatize.isAllAtomsAromatic(iAtomContainer4) && PaDELDearomatize.isAllAtomsAromatic(iAtomContainer3) && PaDELDearomatize.isAllAtomsAromatic(iAtomContainer2))) {
            return false;
        }
        PaDELDearomatize.InvalidateBonds(iAtomContainer4);
        PaDELDearomatize.InvalidateBonds(iAtomContainer3);
        PaDELDearomatize.InvalidateBonds(iAtomContainer2);
        PaDELDearomatize.DearomatizeRing(iAtomContainer4, null, null);
        PaDELDearomatize.DearomatizeRing(iAtomContainer3, null, null);
        PaDELDearomatize.DearomatizeRing(iAtomContainer2, null, null);
        return true;
    }

    private static boolean Dearomatize566Rings(IRingSet iRingSet) {
        IAtom iAtom;
        int n;
        if (iRingSet.getAtomContainerCount() != 3) {
            return false;
        }
        IAtomContainer iAtomContainer = iRingSet.getAtomContainer(0);
        IAtomContainer iAtomContainer2 = iRingSet.getAtomContainer(1);
        IAtomContainer iAtomContainer3 = iRingSet.getAtomContainer(2);
        if (iAtomContainer.getAtomCount() > iAtomContainer2.getAtomCount()) {
            iAtomContainer = iRingSet.getAtomContainer(1);
            iAtomContainer2 = iRingSet.getAtomContainer(0);
        } else if (iAtomContainer.getAtomCount() > iAtomContainer3.getAtomCount()) {
            iAtomContainer = iRingSet.getAtomContainer(2);
            iAtomContainer3 = iRingSet.getAtomContainer(0);
        }
        if (PaDELDearomatize.isMiddleRing(iAtomContainer3, iAtomContainer, iAtomContainer2)) {
            IAtomContainer iAtomContainer4 = iAtomContainer2;
            iAtomContainer2 = iAtomContainer3;
            iAtomContainer3 = iAtomContainer4;
        }
        int n2 = iAtomContainer.getAtomCount();
        int n3 = iAtomContainer2.getAtomCount();
        int n4 = iAtomContainer3.getAtomCount();
        if (n2 != 5 || n3 != 6 || n4 != 6) {
            return false;
        }
        if (!(PaDELDearomatize.isAllAtomsAromatic(iAtomContainer) && PaDELDearomatize.isAllAtomsAromatic(iAtomContainer2) && PaDELDearomatize.isAllAtomsAromatic(iAtomContainer3))) {
            return false;
        }
        PaDELDearomatize.InvalidateBonds(iAtomContainer);
        PaDELDearomatize.InvalidateBonds(iAtomContainer2);
        PaDELDearomatize.InvalidateBonds(iAtomContainer3);
        boolean bl = false;
        IAtom iAtom2 = iAtomContainer.getAtom(0);
        for (n = 0; n < n2; ++n) {
            iAtom = iAtomContainer.getAtom(n);
            if ((iAtom.getAtomicNumber() != 7 || iAtom.getImplicitHydrogenCount() < 1 && iAtom.getFormalNeighbourCount() != 3) && iAtom.getAtomicNumber() != 8 && iAtom.getAtomicNumber() != 16) continue;
            iAtom2 = iAtom;
            bl = true;
            break;
        }
        if (!bl) {
            for (n = 0; n < n2; ++n) {
                iAtom = iAtomContainer.getAtom(n);
                if (iAtomContainer2.contains(iAtom)) {
                    List<IAtom> list = iAtomContainer.getConnectedAtomsList(iAtom);
                    for (IAtom iAtom3 : list) {
                        if (!iAtomContainer2.contains(iAtom3)) {
                            List<IAtom> list2 = iAtomContainer.getConnectedAtomsList(iAtom3);
                            for (IAtom iAtom4 : list2) {
                                if (iAtom4 == iAtom || !iAtomContainer.contains(iAtom4)) continue;
                                iAtom2 = iAtom4;
                                bl = true;
                                break;
                            }
                        }
                        if (!bl) continue;
                        break;
                    }
                }
                if (bl) break;
            }
        }
        IBond iBond = iAtomContainer.getConnectedBondsList(iAtom2).get(0);
        PaDELDearomatize.DearomatizeRing(iAtomContainer, iAtom2, iBond);
        PaDELDearomatize.ConvertNtoNH(iAtomContainer);
        PaDELDearomatize.DearomatizeRing(iAtomContainer2, null, null);
        PaDELDearomatize.DearomatizeRing(iAtomContainer3, null, null);
        return true;
    }

    private static boolean Dearomatize66Rings(IRingSet iRingSet) {
        if (iRingSet.getAtomContainerCount() != 2) {
            return false;
        }
        IAtomContainer iAtomContainer = iRingSet.getAtomContainer(0);
        IAtomContainer iAtomContainer2 = iRingSet.getAtomContainer(1);
        int n = iAtomContainer.getAtomCount();
        int n2 = iAtomContainer2.getAtomCount();
        if (n != 6 || n2 != 6) {
            return false;
        }
        if (!PaDELDearomatize.isAllAtomsAromatic(iAtomContainer) || !PaDELDearomatize.isAllAtomsAromatic(iAtomContainer2)) {
            return false;
        }
        PaDELDearomatize.InvalidateBonds(iAtomContainer);
        PaDELDearomatize.InvalidateBonds(iAtomContainer2);
        PaDELDearomatize.DearomatizeRing(iAtomContainer, null, null);
        PaDELDearomatize.DearomatizeRing(iAtomContainer2, null, null);
        return true;
    }

    private static boolean Dearomatize56Rings(IRingSet iRingSet) {
        IAtom iAtom;
        int n;
        if (iRingSet.getAtomContainerCount() != 2) {
            return false;
        }
        IAtomContainer iAtomContainer = iRingSet.getAtomContainer(0);
        IAtomContainer iAtomContainer2 = iRingSet.getAtomContainer(1);
        if (iAtomContainer.getAtomCount() > iAtomContainer2.getAtomCount()) {
            iAtomContainer = iRingSet.getAtomContainer(1);
            iAtomContainer2 = iRingSet.getAtomContainer(0);
        }
        int n2 = iAtomContainer.getAtomCount();
        int n3 = iAtomContainer2.getAtomCount();
        if (n2 != 5 || n3 != 6) {
            return false;
        }
        if (!PaDELDearomatize.isAllAtomsAromatic(iAtomContainer) || !PaDELDearomatize.isAllAtomsAromatic(iAtomContainer2)) {
            return false;
        }
        PaDELDearomatize.InvalidateBonds(iAtomContainer);
        PaDELDearomatize.InvalidateBonds(iAtomContainer2);
        boolean bl = false;
        IAtom iAtom2 = iAtomContainer.getAtom(0);
        for (n = 0; n < n2; ++n) {
            iAtom = iAtomContainer.getAtom(n);
            if ((iAtom.getAtomicNumber() != 7 || iAtom.getImplicitHydrogenCount() < 1 && iAtom.getFormalNeighbourCount() != 3) && iAtom.getAtomicNumber() != 8 && iAtom.getAtomicNumber() != 16) continue;
            iAtom2 = iAtom;
            bl = true;
            break;
        }
        if (!bl) {
            for (n = 0; n < n2; ++n) {
                iAtom = iAtomContainer.getAtom(n);
                if (iAtomContainer2.contains(iAtom)) {
                    List<IAtom> list = iAtomContainer.getConnectedAtomsList(iAtom);
                    for (IAtom iAtom3 : list) {
                        if (!iAtomContainer2.contains(iAtom3)) {
                            List<IAtom> list2 = iAtomContainer.getConnectedAtomsList(iAtom3);
                            for (IAtom iAtom4 : list2) {
                                if (iAtom4 == iAtom || !iAtomContainer.contains(iAtom4)) continue;
                                iAtom2 = iAtom4;
                                bl = true;
                                break;
                            }
                        }
                        if (!bl) continue;
                        break;
                    }
                }
                if (bl) break;
            }
        }
        IBond iBond = iAtomContainer.getConnectedBondsList(iAtom2).get(0);
        PaDELDearomatize.DearomatizeRing(iAtomContainer, iAtom2, iBond);
        PaDELDearomatize.ConvertNtoNH(iAtomContainer);
        PaDELDearomatize.DearomatizeRing(iAtomContainer2, null, null);
        return true;
    }

    private static boolean Dearomatize6Ring(IRingSet iRingSet) {
        if (iRingSet.getAtomContainerCount() != 1) {
            return false;
        }
        IAtomContainer iAtomContainer = iRingSet.getAtomContainer(0);
        int n = iAtomContainer.getAtomCount();
        if (n != 6) {
            return false;
        }
        if (!PaDELDearomatize.isAllAtomsAromatic(iAtomContainer)) {
            return false;
        }
        PaDELDearomatize.InvalidateBonds(iAtomContainer);
        IAtom iAtom = iAtomContainer.getAtom(0);
        IBond iBond = iAtomContainer.getConnectedBondsList(iAtom).get(0);
        PaDELDearomatize.DearomatizeRing(iAtomContainer, iAtom, iBond);
        return true;
    }

    private static boolean Dearomatize5Ring(IRingSet iRingSet) {
        if (iRingSet.getAtomContainerCount() != 1) {
            return false;
        }
        IAtomContainer iAtomContainer = iRingSet.getAtomContainer(0);
        int n = iAtomContainer.getAtomCount();
        if (n != 5) {
            return false;
        }
        if (!PaDELDearomatize.isAllAtomsAromatic(iAtomContainer)) {
            return false;
        }
        PaDELDearomatize.InvalidateBonds(iAtomContainer);
        IAtom iAtom = iAtomContainer.getAtom(0);
        for (int i = 0; i < n; ++i) {
            IAtom iAtom2 = iAtomContainer.getAtom(i);
            if ((iAtom2.getAtomicNumber() != 7 || iAtom2.getImplicitHydrogenCount() < 1 && iAtom2.getFormalNeighbourCount() != 3) && iAtom2.getAtomicNumber() != 8 && iAtom2.getAtomicNumber() != 16) continue;
            iAtom = iAtom2;
            break;
        }
        IBond iBond = iAtomContainer.getConnectedBondsList(iAtom).get(0);
        PaDELDearomatize.DearomatizeRing(iAtomContainer, iAtom, iBond);
        PaDELDearomatize.ConvertNtoNH(iAtomContainer);
        return true;
    }

    private static boolean DearomatizeAnyBenzeneRing(IRingSet iRingSet) {
        boolean bl = false;
        for (IAtomContainer iAtomContainer : iRingSet.atomContainers()) {
            IChemObject iChemObject2;
            int n = iAtomContainer.getAtomCount();
            if (n != 6 || !PaDELDearomatize.isAllAtomsAromatic(iAtomContainer)) continue;
            boolean bl2 = true;
            for (IChemObject iChemObject2 : iAtomContainer.atoms()) {
                if (iChemObject2.getAtomicNumber() == 6) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            bl = true;
            PaDELDearomatize.InvalidateBonds(iAtomContainer);
            IAtom iAtom = iAtomContainer.getAtom(0);
            iChemObject2 = iAtomContainer.getConnectedBondsList(iAtom).get(0);
            PaDELDearomatize.DearomatizeRing(iAtomContainer, iAtom, (IBond)iChemObject2);
        }
        return bl;
    }

    private static boolean DearomatizeAny5Ring(IRingSet iRingSet) {
        boolean bl = false;
        for (IAtomContainer iAtomContainer : iRingSet.atomContainers()) {
            int n = iAtomContainer.getAtomCount();
            if (n != 5 || !PaDELDearomatize.isAllAtomsAromatic(iAtomContainer)) continue;
            bl = true;
            PaDELDearomatize.InvalidateBonds(iAtomContainer);
            IAtom iAtom = iAtomContainer.getAtom(0);
            for (int i = 0; i < n; ++i) {
                IAtom iAtom2 = iAtomContainer.getAtom(i);
                if ((iAtom2.getAtomicNumber() != 7 || iAtom2.getImplicitHydrogenCount() < 1 && iAtom2.getFormalNeighbourCount() != 3) && iAtom2.getAtomicNumber() != 8 && iAtom2.getAtomicNumber() != 16) continue;
                iAtom = iAtom2;
                break;
            }
            IBond iBond = iAtomContainer.getConnectedBondsList(iAtom).get(0);
            PaDELDearomatize.DearomatizeRing(iAtomContainer, iAtom, iBond);
            PaDELDearomatize.ConvertNtoNH(iAtomContainer);
        }
        return bl;
    }

    private static boolean isAllAtomsAromatic(IAtomContainer iAtomContainer) {
        for (IAtom iAtom : iAtomContainer.atoms()) {
            if (iAtom.getFlag(5)) continue;
            return false;
        }
        return true;
    }

    private static boolean isMiddleRing(IAtomContainer iAtomContainer, IAtomContainer iAtomContainer2, IAtomContainer iAtomContainer3) {
        boolean bl = false;
        boolean bl2 = false;
        for (IAtom iAtom : iAtomContainer.atoms()) {
            if (!bl && iAtomContainer2.contains(iAtom)) {
                bl = true;
                continue;
            }
            if (bl2 || !iAtomContainer3.contains(iAtom)) continue;
            bl2 = true;
        }
        return bl && bl2;
    }

    private static void RemoveAromaticFlag(IAtomContainer iAtomContainer) {
        for (IAtom iChemObject : iAtomContainer.atoms()) {
            iChemObject.setFlag(5, false);
        }
        for (IBond iBond : iAtomContainer.bonds()) {
            iBond.setFlag(5, false);
        }
    }

    private static void InvalidateBonds(IAtomContainer iAtomContainer) {
        for (IBond iBond : iAtomContainer.bonds()) {
            iBond.setOrder(IBond.Order.QUADRUPLE);
        }
    }

    private static void DearomatizeRing(IAtomContainer iAtomContainer, IAtom iAtom, IBond iBond) {
        Object object;
        int n;
        IAtom iAtom2 = iAtom;
        IBond iBond2 = iBond;
        int n2 = iAtomContainer.getBondCount();
        if (iAtom2 == null) {
            iAtom2 = iAtomContainer.getAtom(0);
        }
        if (iBond2 == null) {
            iBond2 = iAtomContainer.getConnectedBondsList(iAtom2).get(0);
        }
        boolean bl = true;
        boolean bl2 = false;
        for (n = 0; n < n2; ++n) {
            object = iAtomContainer.getBond(n);
            if (object.getOrder() == IBond.Order.QUADRUPLE) continue;
            iBond2 = object;
            iAtom2 = object.getAtom(0);
            if (object.getOrder() == IBond.Order.SINGLE) {
                bl = true;
                bl2 = true;
                continue;
            }
            bl = false;
            bl2 = true;
        }
        block1: for (n = 0; n < n2; ++n) {
            if (bl || n == 1 && bl2) {
                iBond2.setOrder(IBond.Order.SINGLE);
                bl = false;
            } else {
                iBond2.setOrder(IBond.Order.DOUBLE);
                bl = true;
            }
            iAtom2 = iBond2.getConnectedAtom(iAtom2);
            object = iAtomContainer.getConnectedBondsList(iAtom2);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                IBond iBond3 = (IBond)iterator.next();
                if (iBond3 == iBond2) continue;
                iBond2 = iBond3;
                continue block1;
            }
        }
        PaDELDearomatize.RemoveAromaticFlag(iAtomContainer);
    }

    private static void ConvertNtoNH(IAtomContainer iAtomContainer) {
        int n = iAtomContainer.getAtomCount();
        for (int i = 0; i < n; ++i) {
            IAtom iAtom = iAtomContainer.getAtom(i);
            if (iAtom.getAtomicNumber() != 7 || iAtom.getHybridization() != IAtomType.Hybridization.SP2) continue;
            List<IBond> list = iAtomContainer.getConnectedBondsList(iAtom);
            boolean bl = true;
            for (IBond iBond : list) {
                if (iBond.getOrder() == IBond.Order.SINGLE) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            iAtom.setHybridization(IAtomType.Hybridization.PLANAR3);
            iAtom.setFormalNeighbourCount(3);
            iAtom.setImplicitHydrogenCount(1);
            iAtom.setAtomTypeName("N.planar3");
        }
    }
}

