/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.Iterator;
import org.openscience.cdk.graph.AtomContainerPermutor;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class AtomContainerBondPermutor
extends AtomContainerPermutor {
    public AtomContainerBondPermutor(IAtomContainer ac) {
        this.setAtomContainer(ac);
        this.N = this.atomContainer.getBondCount();
        this.initBookkeeping();
        this.initObjectArray();
    }

    public void initObjectArray() {
        Iterator<IBond> bonds = this.atomContainer.bonds().iterator();
        this.objects = new Object[this.atomContainer.getBondCount()];
        int i = 0;
        while (bonds.hasNext()) {
            this.objects[i] = bonds.next();
            ++i;
        }
    }

    IAtomContainer makeResult() {
        IBond[] bonds = new IBond[this.objects.length];
        for (int f = 0; f < this.objects.length; ++f) {
            bonds[f] = (IBond)this.objects[f];
        }
        IAtomContainer ac = this.atomContainer.getBuilder().newInstance(IAtomContainer.class, this.atomContainer);
        ac.setBonds(bonds);
        IAtomContainer clone = null;
        try {
            clone = ac.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }
}

