/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.Iterator;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mapping
extends ChemObject
implements Serializable,
Cloneable,
IMapping {
    private static final long serialVersionUID = -6541914644492043503L;
    private IChemObject[] relation = new IChemObject[2];

    public Mapping(IChemObject objectOne, IChemObject objectTwo) {
        this.relation[0] = objectOne;
        this.relation[1] = objectTwo;
    }

    @Override
    public Iterable<IChemObject> relatedChemObjects() {
        return new Iterable<IChemObject>(){

            @Override
            public Iterator<IChemObject> iterator() {
                return new ChemObjectIterator();
            }
        };
    }

    @Override
    public IChemObject getChemObject(int pos) {
        return this.relation[pos];
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Mapping clone = (Mapping)super.clone();
        if (this.relation != null) {
            clone.relation = new IChemObject[this.relation.length];
            for (int f = 0; f < this.relation.length; ++f) {
                if (this.relation[f] == null) continue;
                clone.relation[f] = (IChemObject)this.relation[f].clone();
            }
        }
        return clone;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChemObjectIterator
    implements Iterator<IChemObject> {
        private int pointer = 0;

        private ChemObjectIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < 2;
        }

        @Override
        public IChemObject next() {
            return Mapping.this.relation[this.pointer++];
        }

        @Override
        public void remove() {
        }
    }
}

