/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.base.exceptions.AmbitIOException;
import ambit2.core.io.DelimitedFileFormat;
import ambit2.core.io.ECHAPreregistrationListReader;
import ambit2.core.io.FileState;
import ambit2.core.io.IInputState;
import ambit2.core.io.InteractiveIteratingMDLReader;
import ambit2.core.io.IteratingChemObjectReaderWrapper;
import ambit2.core.io.IteratingDelimitedFileReader;
import ambit2.core.io.IteratingXLSReader;
import ambit2.core.io.ToXMLReaderSimple;
import ambit2.core.io.ToxcastAssayReader;
import ambit2.core.io.ZipReader;
import ambit2.core.io.bcf.EurasBCFReader;
import ambit2.core.io.sj.MalariaHTSDataDelimitedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.CMLReader;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.HINReader;
import org.openscience.cdk.io.INChIReader;
import org.openscience.cdk.io.MDLReader;
import org.openscience.cdk.io.PDBReader;
import org.openscience.cdk.io.formats.IChemFormat;
import org.openscience.cdk.io.iterator.IIteratingChemObjectReader;
import org.openscience.cdk.io.iterator.IteratingSMILESReader;
import org.openscience.cdk.silent.SilentChemObjectBuilder;

public class FileInputState
extends FileState
implements IInputState {
    public static final transient int SDF_INDEX = 0;
    public static final transient int CSV_INDEX = 1;
    public static final transient int SMI_INDEX = 2;
    public static final transient int TXT_INDEX = 3;
    public static final transient int MOL_INDEX = 4;
    public static final transient int ICHI_INDEX = 5;
    public static final transient int INCHI_INDEX = 6;
    public static final transient int CML_INDEX = 7;
    public static final transient int HIN_INDEX = 8;
    public static final transient int PDB_INDEX = 9;
    public static final transient int XLS_INDEX = 10;
    public static final transient int EURAS_INDEX = 11;
    public static final transient int ECHAXML_INDEX = 12;
    public static final transient int TOXML_INDEX = 13;
    public static final transient int MALARIA_HTS_SHEETS = 14;
    public static final transient int ZIP_INDEX = 15;
    public static final transient String[] extensions = new String[]{".sdf", ".csv", ".smi", ".txt", ".mol", ".ichi", ".inchi", ".cml", ".hin", ".pdb", ".xls", ".xls", ".echaxml", ".xml", ".sht", ".zip"};
    public static final transient String[] extensionDescription = new String[]{"SDF files with chemical compounds (*.sdf)", "CSV files (Comma delimited) *.csv)", "SMILES files (*.smi)", "Text files (Tab delimited) (*.txt)", "MDL MOL files (*.mol)", "ICHI files (*.ichi)", "InChI files (*.inchi)", "Chemical Markup Language files (*.cml)", "HIN files (*.hin)", "PDB files (*.pdb)", "Microsoft Office Excel file (*.xls)", "EURAS Excel file with BCF data (*.xls)", "ECHA preregistration list XML format (*.echaxml)", "Leadscope ToXML 3.08 (*.xml)", "Malaria HTS data sheets (*.sht)", "ZIP archive (*.zip)"};

    public FileInputState() {
        this.setSupportedExtDescriptions(extensionDescription);
        this.setSupportedExtensions(extensions);
    }

    public FileInputState(String string) {
        super(string);
        this.setSupportedExtDescriptions(extensionDescription);
        this.setSupportedExtensions(extensions);
    }

    public FileInputState(File file) {
        super(file);
        this.setSupportedExtDescriptions(extensionDescription);
        this.setSupportedExtensions(extensions);
    }

    @Override
    public IIteratingChemObjectReader getReader() throws AmbitIOException {
        try {
            String string = this.filename.toLowerCase();
            return FileInputState.getReader(new FileInputStream(this.getFile()), string, this.fileFormat);
        }
        catch (CDKException cDKException) {
            throw new AmbitIOException((Throwable)cDKException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new AmbitIOException((Throwable)fileNotFoundException);
        }
    }

    public static IIteratingChemObjectReader getReader(InputStream inputStream, String string) throws AmbitIOException, CDKException {
        return FileInputState.getReader(inputStream, string, null);
    }

    public static IIteratingChemObjectReader getReader(InputStream inputStream, String string, IChemFormat iChemFormat) throws AmbitIOException, CDKException {
        if (string.endsWith(extensions[0])) {
            return new InteractiveIteratingMDLReader(inputStream, SilentChemObjectBuilder.getInstance());
        }
        if (string.endsWith(extensions[2])) {
            return new IteratingSMILESReader(inputStream);
        }
        if (string.endsWith(extensions[1])) {
            try {
                if (iChemFormat != null && iChemFormat instanceof DelimitedFileFormat) {
                    return new IteratingDelimitedFileReader(inputStream, (DelimitedFileFormat)iChemFormat);
                }
                return new IteratingDelimitedFileReader(inputStream, new DelimitedFileFormat(",", '\"'));
            }
            catch (Exception exception) {
                throw new AmbitIOException((Throwable)exception);
            }
        }
        if (string.endsWith(extensions[3])) {
            try {
                if (iChemFormat != null && iChemFormat instanceof DelimitedFileFormat) {
                    DelimitedFileFormat delimitedFileFormat = (DelimitedFileFormat)iChemFormat;
                    if (delimitedFileFormat.fieldDelimiter.equals("\t") && delimitedFileFormat.textDelimiter == '\"') {
                        return new ToxcastAssayReader(inputStream);
                    }
                    return new IteratingDelimitedFileReader(inputStream, (DelimitedFileFormat)iChemFormat);
                }
                return new ToxcastAssayReader(inputStream);
            }
            catch (Exception exception) {
                throw new AmbitIOException((Throwable)exception);
            }
        }
        if (string.endsWith(extensions[4])) {
            return new IteratingChemObjectReaderWrapper((DefaultChemObjectReader)new MDLReader(inputStream));
        }
        if (string.endsWith(extensions[6])) {
            return new IteratingChemObjectReaderWrapper((DefaultChemObjectReader)new INChIReader(inputStream));
        }
        if (string.endsWith(extensions[7])) {
            return new IteratingChemObjectReaderWrapper((DefaultChemObjectReader)new CMLReader(inputStream));
        }
        if (string.endsWith(extensions[8])) {
            return new IteratingChemObjectReaderWrapper((DefaultChemObjectReader)new HINReader(inputStream));
        }
        if (string.endsWith(extensions[9])) {
            return new IteratingChemObjectReaderWrapper((DefaultChemObjectReader)new PDBReader(inputStream));
        }
        if (string.toLowerCase().indexOf("euras") >= 0 && string.endsWith(extensions[10])) {
            return new EurasBCFReader(inputStream, 0);
        }
        if (string.endsWith(extensions[10])) {
            return new IteratingXLSReader(inputStream, 0);
        }
        if (string.endsWith(extensions[12])) {
            return new ECHAPreregistrationListReader(inputStream);
        }
        if (string.endsWith(extensions[13])) {
            return new ToXMLReaderSimple(inputStream);
        }
        if (string.endsWith(extensions[14])) {
            return new MalariaHTSDataDelimitedReader(inputStream);
        }
        if (string.endsWith(extensions[15])) {
            return new ZipReader(inputStream);
        }
        throw new AmbitIOException(MSG_UNSUPPORTEDFORMAT + string);
    }
}

