/*
 * Decompiled with CFR 0.152.
 */
package signature.chemistry;

import junit.framework.Assert;
import org.junit.Test;
import signature.chemistry.Molecule;
import signature.chemistry.MoleculeSignature;

public class MultipleBondTest {
    @Test
    public void cocoTest() {
        Molecule moleculeA = new Molecule();
        int chainLength = 6;
        moleculeA.addAtom("O");
        moleculeA.addAtom("C");
        moleculeA.addAtom("C");
        moleculeA.addAtom("O");
        moleculeA.addAtom("C");
        moleculeA.addAtom("O");
        int i = 0;
        while (i < chainLength - 2) {
            moleculeA.addSingleBond(i, i + 1);
            ++i;
        }
        moleculeA.addBond(chainLength - 2, chainLength - 1, 2);
        Molecule moleculeB = new Molecule();
        moleculeB.addAtom("O");
        moleculeB.addAtom("C");
        moleculeB.addAtom("C");
        moleculeB.addAtom("C");
        moleculeB.addAtom("O");
        moleculeB.addAtom("O");
        moleculeB.addBond(0, 1, 1);
        moleculeB.addBond(1, 3, 1);
        moleculeB.addBond(2, 4, 1);
        moleculeB.addBond(2, 5, 2);
        moleculeB.addBond(3, 4, 1);
        MoleculeSignature molSigA = new MoleculeSignature(moleculeA);
        String sigA = molSigA.signatureStringForVertex(3);
        System.out.println(sigA);
        System.out.println("--------------------------------------");
        MoleculeSignature molSigB = new MoleculeSignature(moleculeB);
        String sigB = molSigB.signatureStringForVertex(4);
        System.out.println(sigB);
        Assert.assertEquals((String)sigA, (String)sigB);
    }

    @Test
    public void multipleBondedFragmentTest() {
        Molecule molA = new Molecule();
        molA.addAtom("C");
        molA.addAtom("C");
        molA.addAtom("C");
        molA.addAtom("H");
        molA.addBond(0, 1, 2);
        molA.addBond(0, 2, 1);
        molA.addBond(0, 3, 1);
        MoleculeSignature molSig = new MoleculeSignature(molA);
        String signatureFor0A = molSig.signatureStringForVertex(0);
        System.out.println(signatureFor0A);
        Molecule molB = new Molecule();
        molB.addAtom("C");
        molB.addAtom("C");
        molB.addAtom("C");
        molB.addAtom("H");
        molB.addBond(0, 1, 1);
        molB.addBond(0, 2, 2);
        molB.addBond(0, 3, 1);
        molSig = new MoleculeSignature(molB);
        String signatureFor0B = molSig.signatureStringForVertex(0);
        System.out.println(signatureFor0B);
        Assert.assertEquals((String)signatureFor0A, (String)signatureFor0B);
    }

    @Test
    public void cyclobut_1_ene() {
        Molecule mol = new Molecule();
        int i = 0;
        while (i < 4) {
            mol.addAtom("C");
            ++i;
        }
        mol.addBond(0, 1, 1);
        mol.addBond(0, 2, 2);
        mol.addBond(1, 3, 1);
        mol.addBond(2, 3, 1);
        MoleculeSignature molSignature = new MoleculeSignature(mol);
        System.out.println(molSignature.toCanonicalString());
    }

    @Test
    public void cyclobut_2_ene() {
        Molecule mol = new Molecule();
        int i = 0;
        while (i < 4) {
            mol.addAtom("C");
            ++i;
        }
        mol.addBond(0, 1, 1);
        mol.addBond(0, 2, 2);
        mol.addBond(1, 3, 2);
        mol.addBond(2, 3, 1);
        MoleculeSignature molSignature = new MoleculeSignature(mol);
        System.out.println(molSignature.toCanonicalString());
    }

    @Test
    public void benzeneTest() {
        Molecule mol = new Molecule();
        int i = 0;
        while (i < 6) {
            mol.addAtom("C");
            ++i;
        }
        mol.addBond(0, 1, 1);
        mol.addBond(1, 2, 2);
        mol.addBond(2, 3, 1);
        mol.addBond(3, 4, 2);
        mol.addBond(4, 5, 1);
        mol.addBond(5, 0, 2);
        MoleculeSignature molSig = new MoleculeSignature(mol);
        String sigString0 = molSig.signatureStringForVertex(0);
        int i2 = 1;
        while (i2 < 6) {
            String sigStringI = molSig.signatureStringForVertex(i2);
            Assert.assertEquals((String)sigString0, (String)sigStringI);
            ++i2;
        }
    }
}

