/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.BondCountDescriptorTest")
public class BondCountDescriptor
implements IMolecularDescriptor {
    private String order = "";

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#bondCount", this.getClass().getName(), "$Id: 4ab99dbfe795d438d8ce73a52bbc24fe8a95c7ad $", "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("BondCount only expects one parameter");
        }
        if (!(params[0] instanceof String)) {
            throw new CDKException("The parameter must be of type IBond.Order");
        }
        String bondType = (String)params[0];
        if (bondType.length() > 1 || !"sdtq".contains(bondType)) {
            throw new CDKException("The only allowed values for this parameter are 's', 'd', 't', 'q' and ''.");
        }
        this.order = bondType;
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] params = new Object[]{this.order};
        return params;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        if (this.order.equals("")) {
            return new String[]{"nB"};
        }
        return new String[]{"nB" + this.order};
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer container) {
        if (this.order.equals("")) {
            int bondCount = 0;
            for (IBond bond : container.bonds()) {
                boolean hasHydrogen = false;
                for (int i = 0; i < bond.getAtomCount(); ++i) {
                    if (!bond.getAtom(i).getSymbol().equals("H")) continue;
                    hasHydrogen = true;
                    break;
                }
                if (hasHydrogen) continue;
                ++bondCount;
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(bondCount), this.getDescriptorNames(), null);
        }
        int bondCount = 0;
        for (IBond bond : container.bonds()) {
            if (!this.bondMatch(bond.getOrder(), this.order)) continue;
            ++bondCount;
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(bondCount), this.getDescriptorNames());
    }

    private boolean bondMatch(IBond.Order order, String orderString) {
        if (order == IBond.Order.SINGLE && "s".equals(orderString)) {
            return true;
        }
        if (order == IBond.Order.DOUBLE && "d".equals(orderString)) {
            return true;
        }
        if (order == IBond.Order.TRIPLE && "t".equals(orderString)) {
            return true;
        }
        return order == IBond.Order.QUADRUPLE && "q".equals(orderString);
    }

    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] params = new String[]{"order"};
        return params;
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        if ("order".equals(name)) {
            return "";
        }
        return null;
    }
}

