/*
 * Decompiled with CFR 0.152.
 */
package ambit2.base.external;

import ambit2.base.exceptions.AmbitException;
import ambit2.base.external.Command;
import ambit2.base.external.ShellException;
import ambit2.base.interfaces.IProcessor;
import ambit2.base.io.DownloadTool;
import ambit2.base.log.AmbitLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public abstract class CommandShell<INPUT, OUTPUT>
implements IProcessor<INPUT, OUTPUT> {
    private static final long serialVersionUID = -5771392099125415099L;
    protected String prefix = "ambit2/";
    public static final String os_MAC = "Mac OS";
    public static final String os_WINDOWS = "Windows";
    public static final String os_WINDOWSVISTA = "Windows Vista";
    public static final String os_WINDOWS7 = "Windows 7";
    public static final String os_LINUX = "Linux";
    public static final String os_FreeBSD = "FreeBSD";
    protected static AmbitLogger logger = new AmbitLogger(CommandShell.class);
    protected Hashtable<String, Command> executables = new Hashtable();
    protected String inputFile = null;
    protected String outputFile = null;
    protected boolean runAsync = false;
    protected boolean enabled = true;
    protected int exitCode = 0;

    @Override
    public long getID() {
        return 0L;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    protected CommandShell() throws ShellException {
        this.initialize();
    }

    public synchronized int getExitCode() {
        return this.exitCode;
    }

    public synchronized void setExitCode(int n) {
        this.exitCode = n;
    }

    protected void initialize() throws ShellException {
    }

    public String addExecutable(String string, String[] stringArray) throws ShellException {
        return this.addExecutable(System.getProperty("os.name"), string, stringArray);
    }

    public String addExecutable(String string, String string2, String[] stringArray) throws ShellException {
        this.executables.put(string, new Command(string2, stringArray));
        return string2;
    }

    public String addExecutableMac(String string, String[] stringArray) throws ShellException {
        return this.addExecutable(os_MAC, string, stringArray);
    }

    public String addExecutableWin(String string, String[] stringArray) throws ShellException {
        this.addExecutable(os_WINDOWSVISTA, string, stringArray);
        return this.addExecutable(os_WINDOWS, string, stringArray);
    }

    public String addExecutableLinux(String string, String[] stringArray) throws ShellException {
        return this.addExecutable(os_LINUX, string, stringArray);
    }

    public String addExecutableFreeBSD(String string, String[] stringArray) throws ShellException {
        return this.addExecutable(os_FreeBSD, string, stringArray);
    }

    public synchronized String getExecutable(String string) throws Exception {
        Command command = this.executables.get(string);
        String string2 = command.getExe();
        File file = new File(string2);
        if (!file.exists()) {
            String string3 = this.getHomeDir(file);
            if (!(file = new File(string3, string2)).exists()) {
                logger.info("Writing " + string2 + " to " + file);
                DownloadTool.download(this.prefix + string2, file);
                command.setExe(file.getAbsolutePath());
                try {
                    Runtime.getRuntime().exec(String.format("chmod +x %s", file.getAbsolutePath()));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (command.getAdditionalFiles() != null) {
                for (String string4 : command.getAdditionalFiles()) {
                    File file2 = new File(string3, string4);
                    if (file2.exists()) continue;
                    DownloadTool.download(this.prefix + string4, file2);
                }
            }
            command.setExe(file.getAbsolutePath());
        }
        return this.executables.get(string).getExe();
    }

    public String getExecutable() throws ShellException {
        String string = System.getProperty("os.name");
        Enumeration<String> enumeration = this.executables.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (!string.startsWith(string2)) continue;
            try {
                String string3 = this.getExecutable(string2);
                if (string3 == null) continue;
                return string3;
            }
            catch (IOException iOException) {
                throw new ShellException(this, "Not found");
            }
            catch (Exception exception) {
                throw new ShellException(this, "Not supported for " + string);
            }
        }
        throw new ShellException(this, "Not supported for " + string);
    }

    public synchronized OUTPUT runShell(INPUT INPUT) throws ShellException {
        return this.runShell(INPUT, this.getExecutable());
    }

    @Override
    public synchronized OUTPUT process(INPUT INPUT) throws AmbitException {
        try {
            return this.runShell(INPUT);
        }
        catch (ShellException shellException) {
            throw new AmbitException(shellException);
        }
    }

    protected synchronized List<String> prepareInput(String string, INPUT INPUT) throws ShellException {
        return null;
    }

    protected abstract OUTPUT parseOutput(String var1, INPUT var2) throws ShellException;

    protected String getPath(File file) {
        String string = file.getAbsolutePath();
        int n = string.lastIndexOf(File.separatorChar);
        string = n > -1 ? string.substring(0, n) : "";
        return string;
    }

    protected String getHomeDir(File file) {
        return System.getProperty("user.home") + "/.ambit2";
    }

    protected synchronized INPUT transform_input(INPUT INPUT) throws ShellException {
        return INPUT;
    }

    protected synchronized OUTPUT runShell(INPUT INPUT, String string) throws ShellException {
        try {
            this.setExitCode(0);
            File file = new File(string);
            String string2 = this.getPath(file);
            INPUT INPUT2 = this.transform_input(INPUT);
            List<String> list = this.prepareInput(string2, INPUT2);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add(list.get(i));
                }
            }
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            processBuilder.directory(new File(string2));
            Map<String, String> map = processBuilder.environment();
            processBuilder.directory(new File(string2));
            if (!this.runAsync) {
                String string3;
                processBuilder.redirectErrorStream(true);
                logger.info("<" + this.toString() + " filename=\"" + string + "\">");
                logger.debug("<environ>");
                logger.debug(map);
                logger.debug("</environ>");
                long l = System.currentTimeMillis();
                Process process = processBuilder.start();
                InputStream inputStream = process.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                logger.info("<stdout>");
                while ((string3 = bufferedReader.readLine()) != null) {
                    logger.info(string3);
                }
                bufferedReader.close();
                logger.info("</stdout>");
                logger.info("<wait process=\"" + string + "\">");
                this.setExitCode(process.waitFor());
                logger.info("</wait>");
                logger.info("<exitcode value=\"" + Integer.toString(this.getExitCode()) + "\">");
                logger.info("<elapsed_time units=\"ms\">" + Long.toString(System.currentTimeMillis() - l) + "</elapsed_time>");
                logger.info("</" + this.toString() + ">");
                OUTPUT OUTPUT = null;
                if (this.exitCodeOK(this.getExitCode())) {
                    logger.info("<parse>");
                    OUTPUT = this.parseOutput(string2, INPUT2);
                    logger.info("</parse>");
                }
                return OUTPUT;
            }
            Process process = processBuilder.start();
            return this.transform(process, INPUT2);
        }
        catch (Throwable throwable) {
            logger.debug(throwable.getMessage());
            throw new ShellException(this, throwable);
        }
    }

    protected synchronized OUTPUT transform(Process process, INPUT INPUT) {
        return this.transform(INPUT);
    }

    protected boolean exitCodeOK(int n) {
        return n == 0;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(String string) {
        this.inputFile = string;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String string) {
        this.outputFile = string;
    }

    protected abstract OUTPUT transform(INPUT var1);
}

