/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.core.io.DelimitedFileFormat;
import ambit2.core.io.FilesWithHeaderWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.MoleculeSet;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.smiles.SmilesGenerator;

public class DelimitedFileWriter
extends FilesWithHeaderWriter {
    protected BufferedWriter writer;
    protected DelimitedFileFormat format;
    protected SmilesGenerator sg = new SmilesGenerator(true);

    public DelimitedFileWriter(Writer writer, DelimitedFileFormat delimitedFileFormat) {
        this.format = delimitedFileFormat;
        try {
            this.writer = new BufferedWriter(writer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DelimitedFileWriter(Writer writer) {
        this(writer, new DelimitedFileFormat());
    }

    public DelimitedFileWriter(OutputStream outputStream, DelimitedFileFormat delimitedFileFormat) {
        this(new OutputStreamWriter(outputStream), delimitedFileFormat);
    }

    public DelimitedFileWriter(OutputStream outputStream) {
        this(outputStream, new DelimitedFileFormat());
    }

    public void write(IChemObject iChemObject) throws CDKException {
        if (iChemObject instanceof IMoleculeSet) {
            this.writeSetOfMolecules((IMoleculeSet)iChemObject);
        } else if (iChemObject instanceof IMolecule) {
            this.writeMolecule((IMolecule)iChemObject);
        } else {
            throw new CDKException("Only supported is writing of ChemFile and Molecule objects.");
        }
    }

    public ChemObject highestSupportedChemObject() {
        return new MoleculeSet();
    }

    public IResourceFormat getFormat() {
        return this.format;
    }

    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    public void writeSetOfMolecules(IMoleculeSet iMoleculeSet) {
        for (int i = 0; i < iMoleculeSet.getMoleculeCount(); ++i) {
            try {
                this.writeMolecule(iMoleculeSet.getMolecule(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void writeHeader() throws IOException {
        String string = this.format.getFieldDelimiter().substring(0, 1);
        char c = this.format.getTextDelimiter();
        for (int i = 0; i < this.header.size(); ++i) {
            String string2 = this.header.get(i).toString();
            if (string2.indexOf(string) > -1) {
                this.writer.write(c);
                this.writer.write(string2);
                this.writer.write(c);
            } else {
                this.writer.write(string2);
            }
            this.writer.write(string);
        }
        this.writer.newLine();
        logger.debug((Object)this.format.getFormatName(), new Object[]{"\tHeader written\t", this.header});
    }

    public void writeMolecule(IMolecule iMolecule) {
        String string = this.format.getFieldDelimiter().substring(0, 1);
        char c = this.format.getTextDelimiter();
        try {
            if (!this.writingStarted) {
                if (this.header == null) {
                    this.setHeader(iMolecule.getProperties());
                }
                this.writeHeader();
                this.writingStarted = true;
            }
            for (int i = 0; i < this.header.size(); ++i) {
                Object object = iMolecule.getProperty(this.header.get(i));
                if (i == this.smilesIndex && object == null) {
                    try {
                        object = this.sg.createSMILES((IAtomContainer)iMolecule);
                    }
                    catch (Exception exception) {
                        logger.error((Object)"Error while createSMILES\t", new Object[]{exception.getMessage()});
                        object = "";
                    }
                }
                if (object != null) {
                    if (object instanceof Number) {
                        this.writer.write(object.toString());
                    } else {
                        String string2 = object.toString();
                        if (string2.indexOf(c) > -1) {
                            string2 = string2.replace(c, ' ');
                        }
                        if ((string2 = string2.trim()).indexOf(string) > -1) {
                            this.writer.write(c);
                            this.writer.write(string2);
                            this.writer.write(c);
                        } else {
                            this.writer.write(string2);
                        }
                    }
                }
                if (i >= this.header.size() - 1) continue;
                this.writer.write(string);
            }
            this.writer.newLine();
            this.writer.flush();
            logger.debug((Object)"file flushed...");
        }
        catch (Exception exception) {
            logger.error((Object)"ERROR while writing Molecule: ", new Object[]{exception.getMessage()});
            logger.debug((Object)exception);
            exception.printStackTrace();
        }
    }

    public String toString() {
        return "Writing compounds to " + this.format.toString();
    }

    public boolean accepts(Class clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (IChemFile.class.equals(classArray[i])) {
                return true;
            }
            if (!IMoleculeSet.class.equals(classArray[i])) continue;
            return true;
        }
        return false;
    }

    public int getSupportedDataFeatures() {
        return 512;
    }

    public void setWriter(OutputStream outputStream) throws CDKException {
        this.setWriter(new OutputStreamWriter(outputStream));
    }

    public void setWriter(Writer writer) throws CDKException {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                logger.error((Object)iOException);
            }
            this.writer = null;
        }
        this.writer = new BufferedWriter(writer);
    }
}

