/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.core.io.SimpleTokenizer;

public class QuotedTokenizer
extends SimpleTokenizer {
    private static final char DOUBLE_QUOTE = '\"';
    private char delimiter;

    public QuotedTokenizer(String string, char c) {
        super(string, String.valueOf(c), true);
        this.delimiter = c;
    }

    @Override
    public void setDelimiter(String string) {
        if (string.length() != 1) {
            throw new IllegalArgumentException("Delimiter must be a single character");
        }
        this.delimiter = string.charAt(0);
        super.setDelimiter(string);
    }

    @Override
    protected String parseToken() {
        if (this.text.charAt(this.position) == '\"') {
            return this.parseQuotedToken();
        }
        return super.parseToken();
    }

    private String parseQuotedToken() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        boolean bl2 = true;
        ++this.position;
        while (this.position < this.maxPosition) {
            char c = this.text.charAt(this.position);
            if (c == '\"') {
                if (!bl2) {
                    stringBuffer.append(c);
                }
                bl2 = !bl2;
                ++this.position;
                continue;
            }
            if (c == this.delimiter && !bl2) {
                bl = false;
                ++this.position;
                break;
            }
            stringBuffer.append(c);
            ++this.position;
        }
        if (bl) {
            ++this.position;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        QuotedTokenizer quotedTokenizer = new QuotedTokenizer(stringArray[1], stringArray[0].charAt(0));
        quotedTokenizer.setText(stringArray[1]);
        while (quotedTokenizer.hasMoreTokens()) {
            System.out.print(":");
            System.out.print(quotedTokenizer.nextToken());
            System.out.println(":");
        }
    }
}

