/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.enhanced;

import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Personality;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.util.cache.Cache;
import com.hp.hpl.jena.util.cache.CacheControl;
import com.hp.hpl.jena.util.cache.CacheManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhGraph {
    protected Graph graph;
    private static int cnt = 0;
    protected Cache enhNodes = CacheManager.createCache("ENHNODECACHE", "EnhGraph-" + cnt++, 1000);
    private Personality<RDFNode> personality;

    public EnhGraph(Graph g, Personality<RDFNode> p) {
        this.graph = g;
        this.personality = p;
    }

    public Graph asGraph() {
        return this.graph;
    }

    public final int hashCode() {
        return this.graph.hashCode();
    }

    public final boolean equals(Object o) {
        return this == o || o instanceof EnhGraph && this.graph.equals(((EnhGraph)o).asGraph());
    }

    public final boolean isIsomorphicWith(EnhGraph eg) {
        return this.graph.isIsomorphicWith(eg.graph);
    }

    public <X extends RDFNode> X getNodeAs(Node n, Class<X> interf) {
        EnhNode eh = (EnhNode)this.enhNodes.get(n);
        if (eh == null) {
            RDFNode constructed = (RDFNode)this.personality.newInstance(interf, n, this);
            this.enhNodes.put(n, constructed);
            return (X)constructed;
        }
        return eh.viewAs(interf);
    }

    public CacheControl getNodeCacheControl() {
        return this.enhNodes;
    }

    public void setNodeCache(Cache cc) {
        this.enhNodes = cc;
    }

    protected Personality<RDFNode> getPersonality() {
        return this.personality;
    }
}

