/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.util.List;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerArrayResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class PaDELHBondAcceptorCountDescriptor
implements IMolecularDescriptor {
    private boolean checkAromaticity = false;
    private static final String[] names = new String[]{"nHBAcc", "nHBAcc2", "nHBAcc3", "nHBAcc_Lipinski"};

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("PaDELHBondAcceptorCountDescriptor", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] objectArray) throws CDKException {
        if (objectArray.length != 1) {
            throw new CDKException("PaDELHBondAcceptorCountDescriptor expects a single parameter");
        }
        if (!(objectArray[0] instanceof Boolean)) {
            throw new CDKException("The parameter must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)objectArray[0];
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] objectArray = new Object[]{this.checkAromaticity};
        return objectArray;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        IntegerArrayResult integerArrayResult = new IntegerArrayResult(this.getDescriptorNames().length);
        int n = this.getDescriptorNames().length;
        for (int i = 0; i < n; ++i) {
            integerArrayResult.add(0);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), integerArrayResult, this.getDescriptorNames(), exception);
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        IAtomContainer iAtomContainer2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            iAtomContainer2 = iAtomContainer.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this.getDummyDescriptorValue(cloneNotSupportedException);
        }
        if (this.checkAromaticity) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(iAtomContainer2);
                CDKHueckelAromaticityDetector.detectAromaticity(iAtomContainer2);
            }
            catch (CDKException cDKException) {
                return this.getDummyDescriptorValue(cDKException);
            }
        }
        for (int i = 0; i < iAtomContainer2.getAtomCount(); ++i) {
            boolean bl;
            IAtom iAtom = iAtomContainer2.getAtom(i);
            List<IAtom> list = iAtomContainer2.getConnectedAtomsList(iAtom);
            if (iAtom.getSymbol().equals("N")) {
                Object object;
                Object object22;
                ++n4;
                bl = true;
                boolean bl2 = true;
                boolean bl3 = true;
                if (iAtom.getFormalCharge() > 0) {
                    bl = false;
                    bl2 = false;
                    bl3 = false;
                }
                if ((bl2 || bl3) && iAtom.getFlag(5) && iAtom.getFlag(1)) {
                    Integer n5 = iAtom.getImplicitHydrogenCount();
                    if (n5 == CDKConstants.UNSET) {
                        n5 = 0;
                    }
                    if (n5 > 0) {
                        bl2 = false;
                        bl3 = false;
                    }
                    if (list.size() >= 3) {
                        bl2 = false;
                        bl3 = false;
                    }
                    if (bl2 || bl3) {
                        for (Object object22 : list) {
                            if (!((IAtom)object22).getSymbol().equals("H")) continue;
                            bl2 = false;
                            bl3 = false;
                            break;
                        }
                    }
                }
                if (bl2 || bl3) {
                    int n6 = 0;
                    for (Object object22 : list) {
                        object = iAtomContainer2.getBond(iAtom, (IAtom)object22).getOrder();
                        if (object == IBond.Order.SINGLE) {
                            ++n6;
                            continue;
                        }
                        if (object == IBond.Order.DOUBLE) {
                            n6 += 2;
                            continue;
                        }
                        if (object == IBond.Order.TRIPLE) {
                            n6 += 3;
                            continue;
                        }
                        if (object != IBond.Order.QUADRUPLE) continue;
                        n6 += 4;
                    }
                    if (n6 >= 4) {
                        bl2 = false;
                        bl3 = false;
                    }
                }
                if (bl3) {
                    for (Object object3 : list) {
                        if (!((IAtom)object3).getSymbol().equals("C")) continue;
                        object22 = iAtomContainer2.getConnectedAtomsList((IAtom)object3);
                        object = object22.iterator();
                        while (object.hasNext()) {
                            Object e = object.next();
                            if (!((IAtom)e).getSymbol().equals("O") || iAtomContainer2.getBond((IAtom)object3, (IAtom)e).getOrder() != IBond.Order.DOUBLE) continue;
                            bl3 = false;
                            break;
                        }
                        if (bl3) continue;
                        break;
                    }
                }
                if (bl || bl2 || bl3) {
                    boolean bl4 = false;
                    boolean bl5 = false;
                    object22 = list.iterator();
                    while (object22.hasNext()) {
                        object = object22.next();
                        if (((IAtom)object).getSymbol().equals("O")) {
                            bl4 = true;
                        }
                        if (((IAtom)object).getFlag(5)) {
                            bl5 = true;
                        }
                        if (!bl4) continue;
                        bl = false;
                        if (!bl5 || iAtom.getFlag(5)) continue;
                        bl2 = false;
                        bl3 = false;
                        break;
                    }
                }
                if (bl) {
                    ++n;
                }
                if (bl2) {
                    ++n2;
                }
                if (bl3) {
                    ++n3;
                }
            }
            if (iAtom.getSymbol().equals("O")) {
                ++n4;
                ++n2;
                ++n3;
                bl = true;
                if (iAtom.getFormalCharge() > 0) {
                    bl = false;
                }
                if (bl) {
                    for (IAtom iAtom2 : list) {
                        if (!iAtom2.getSymbol().equals("N") && (!iAtom2.getSymbol().equals("C") || !iAtom2.getFlag(5))) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) {
                    ++n;
                }
            }
            if (!iAtom.getSymbol().equals("F")) continue;
            ++n2;
            ++n3;
        }
        IntegerArrayResult integerArrayResult = new IntegerArrayResult();
        integerArrayResult.add(n);
        integerArrayResult.add(n2);
        integerArrayResult.add(n3);
        integerArrayResult.add(n4);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), integerArrayResult, this.getDescriptorNames());
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerArrayResult(names.length);
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] stringArray = new String[]{"checkAromaticity"};
        return stringArray;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String string) {
        return false;
    }
}

