/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Element;

public class Pattern {
    public final Element S;
    public final Element P;
    public final Element O;

    public Pattern(Element S, Element P, Element O) {
        this.S = S;
        this.P = P;
        this.O = O;
    }

    public TripleMatch asTripleMatch(Domain d) {
        return Triple.createMatch(this.S.asNodeMatch(d), this.P.asNodeMatch(d), this.O.asNodeMatch(d));
    }

    public boolean match(Domain d, Triple t) {
        return this.S.match(d, t.getSubject()) && this.P.match(d, t.getPredicate()) && this.O.match(d, t.getObject());
    }

    public String toString() {
        return "<pattern " + this.S + " @" + this.P + " " + this.O + ">";
    }
}

